package io.k8s.api.networking.v1

import dev.hnaderi.k8s.utils._

/** NetworkPolicyPeer describes a peer to allow traffic to/from. Only certain combinations of fields are allowed */
final case class NetworkPolicyPeer(
  ipBlock : Option[io.k8s.api.networking.v1.IPBlock] = None,
  namespaceSelector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None,
  podSelector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None
) {

  /** Returns a new data with ipBlock set to new value */
  def withIpBlock(value: io.k8s.api.networking.v1.IPBlock) : NetworkPolicyPeer = copy(ipBlock = Some(value))
  /** if ipBlock has a value, transforms to the result of function*/
  def mapIpBlock(f: io.k8s.api.networking.v1.IPBlock => io.k8s.api.networking.v1.IPBlock) : NetworkPolicyPeer = copy(ipBlock = ipBlock.map(f))

  /** Returns a new data with namespaceSelector set to new value */
  def withNamespaceSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : NetworkPolicyPeer = copy(namespaceSelector = Some(value))
  /** if namespaceSelector has a value, transforms to the result of function*/
  def mapNamespaceSelector(f: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector => io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : NetworkPolicyPeer = copy(namespaceSelector = namespaceSelector.map(f))

  /** Returns a new data with podSelector set to new value */
  def withPodSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : NetworkPolicyPeer = copy(podSelector = Some(value))
  /** if podSelector has a value, transforms to the result of function*/
  def mapPodSelector(f: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector => io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : NetworkPolicyPeer = copy(podSelector = podSelector.map(f))
}

object NetworkPolicyPeer {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.networking.v1.NetworkPolicyPeer, T] = new Encoder[io.k8s.api.networking.v1.NetworkPolicyPeer, T] {
        def apply(o: io.k8s.api.networking.v1.NetworkPolicyPeer) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("ipBlock", o.ipBlock)
            .write("namespaceSelector", o.namespaceSelector)
            .write("podSelector", o.podSelector)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, NetworkPolicyPeer] = new Decoder[T, NetworkPolicyPeer] {
      def apply(t: T): Either[String, NetworkPolicyPeer] = for {
          obj <- ObjectReader(t)
          ipBlock <- obj.readOpt[io.k8s.api.networking.v1.IPBlock]("ipBlock")
          namespaceSelector <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]("namespaceSelector")
          podSelector <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]("podSelector")
      } yield NetworkPolicyPeer (
          ipBlock = ipBlock,
          namespaceSelector = namespaceSelector,
          podSelector = podSelector
        )
    }
}

