package io.k8s.api.networking.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** NetworkPolicyList is a list of NetworkPolicy objects. */
final case class NetworkPolicyList(
  items : Seq[io.k8s.api.networking.v1.NetworkPolicy],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("networking.k8s.io", "NetworkPolicyList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.networking.v1.NetworkPolicy]) : NetworkPolicyList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.networking.v1.NetworkPolicy*) : NetworkPolicyList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.networking.v1.NetworkPolicy] => Seq[io.k8s.api.networking.v1.NetworkPolicy]) : NetworkPolicyList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : NetworkPolicyList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : NetworkPolicyList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = NetworkPolicyList.encoder[T].apply(this)
}

object NetworkPolicyList {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.networking.v1.NetworkPolicyList, T] = new Encoder[io.k8s.api.networking.v1.NetworkPolicyList, T] {
        def apply(o: io.k8s.api.networking.v1.NetworkPolicyList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, NetworkPolicyList] = new Decoder[T, NetworkPolicyList] {
      def apply(t: T): Either[String, NetworkPolicyList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.networking.v1.NetworkPolicy]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield NetworkPolicyList (
          items = items,
          metadata = metadata
        )
    }
}

