package io.k8s.api.networking.v1

import dev.hnaderi.k8s.utils._

/** HTTPIngressRuleValue is a list of http selectors pointing to backends. In the example: http://<host>/<path>?<searchpart> -> backend where where parts of the url correspond to RFC 3986, this resource will be used to match against everything after the last '/' and before the first '?' or '#'. */
final case class HTTPIngressRuleValue(
  paths : Seq[io.k8s.api.networking.v1.HTTPIngressPath]
) {

  /** Returns a new data with paths set to new value */
  def withPaths(value: Seq[io.k8s.api.networking.v1.HTTPIngressPath]) : HTTPIngressRuleValue = copy(paths = value)
  /** Appends new values to paths */
  def addPaths(newValues: io.k8s.api.networking.v1.HTTPIngressPath*) : HTTPIngressRuleValue = copy(paths = paths ++ newValues)
  /** transforms paths to result of function */
  def mapPaths(f: Seq[io.k8s.api.networking.v1.HTTPIngressPath] => Seq[io.k8s.api.networking.v1.HTTPIngressPath]) : HTTPIngressRuleValue = copy(paths = f(paths))
}

object HTTPIngressRuleValue {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.networking.v1.HTTPIngressRuleValue, T] = new Encoder[io.k8s.api.networking.v1.HTTPIngressRuleValue, T] {
        def apply(o: io.k8s.api.networking.v1.HTTPIngressRuleValue) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("paths", o.paths)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, HTTPIngressRuleValue] = new Decoder[T, HTTPIngressRuleValue] {
      def apply(t: T): Either[String, HTTPIngressRuleValue] = for {
          obj <- ObjectReader(t)
          paths <- obj.read[Seq[io.k8s.api.networking.v1.HTTPIngressPath]]("paths")
      } yield HTTPIngressRuleValue (
          paths = paths
        )
    }
}

