package io.k8s.api.flowcontrol.v1beta2

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** FlowSchemaList is a list of FlowSchema objects. */
final case class FlowSchemaList(
  items : Seq[io.k8s.api.flowcontrol.v1beta2.FlowSchema],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("flowcontrol.apiserver.k8s.io", "FlowSchemaList", "v1beta2")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.flowcontrol.v1beta2.FlowSchema]) : FlowSchemaList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.flowcontrol.v1beta2.FlowSchema*) : FlowSchemaList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.flowcontrol.v1beta2.FlowSchema] => Seq[io.k8s.api.flowcontrol.v1beta2.FlowSchema]) : FlowSchemaList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : FlowSchemaList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : FlowSchemaList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = FlowSchemaList.encoder[T].apply(this)
}

object FlowSchemaList {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.flowcontrol.v1beta2.FlowSchemaList, T] = new Encoder[io.k8s.api.flowcontrol.v1beta2.FlowSchemaList, T] {
        def apply(o: io.k8s.api.flowcontrol.v1beta2.FlowSchemaList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, FlowSchemaList] = new Decoder[T, FlowSchemaList] {
      def apply(t: T): Either[String, FlowSchemaList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.flowcontrol.v1beta2.FlowSchema]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield FlowSchemaList (
          items = items,
          metadata = metadata
        )
    }
}

