package io.k8s.api.flowcontrol.v1beta1

import dev.hnaderi.k8s.utils._

/** FlowSchemaStatus represents the current state of a FlowSchema. */
final case class FlowSchemaStatus(
  conditions : Option[Seq[io.k8s.api.flowcontrol.v1beta1.FlowSchemaCondition]] = None
) {

  /** Returns a new data with conditions set to new value */
  def withConditions(value: Seq[io.k8s.api.flowcontrol.v1beta1.FlowSchemaCondition]) : FlowSchemaStatus = copy(conditions = Some(value))
  /** Appends new values to conditions */
  def addConditions(newValues: io.k8s.api.flowcontrol.v1beta1.FlowSchemaCondition*) : FlowSchemaStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))
  /** if conditions has a value, transforms to the result of function*/
  def mapConditions(f: Seq[io.k8s.api.flowcontrol.v1beta1.FlowSchemaCondition] => Seq[io.k8s.api.flowcontrol.v1beta1.FlowSchemaCondition]) : FlowSchemaStatus = copy(conditions = conditions.map(f))
}

object FlowSchemaStatus {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.flowcontrol.v1beta1.FlowSchemaStatus, T] = new Encoder[io.k8s.api.flowcontrol.v1beta1.FlowSchemaStatus, T] {
        def apply(o: io.k8s.api.flowcontrol.v1beta1.FlowSchemaStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("conditions", o.conditions)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, FlowSchemaStatus] = new Decoder[T, FlowSchemaStatus] {
      def apply(t: T): Either[String, FlowSchemaStatus] = for {
          obj <- ObjectReader(t)
          conditions <- obj.readOpt[Seq[io.k8s.api.flowcontrol.v1beta1.FlowSchemaCondition]]("conditions")
      } yield FlowSchemaStatus (
          conditions = conditions
        )
    }
}

