package io.k8s.api.discovery.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** EndpointSliceList represents a list of endpoint slices */
final case class EndpointSliceList(
  items : Seq[io.k8s.api.discovery.v1.EndpointSlice],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("discovery.k8s.io", "EndpointSliceList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.discovery.v1.EndpointSlice]) : EndpointSliceList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.discovery.v1.EndpointSlice*) : EndpointSliceList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.discovery.v1.EndpointSlice] => Seq[io.k8s.api.discovery.v1.EndpointSlice]) : EndpointSliceList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : EndpointSliceList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : EndpointSliceList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = EndpointSliceList.encoder[T].apply(this)
}

object EndpointSliceList {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.discovery.v1.EndpointSliceList, T] = new Encoder[io.k8s.api.discovery.v1.EndpointSliceList, T] {
        def apply(o: io.k8s.api.discovery.v1.EndpointSliceList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, EndpointSliceList] = new Decoder[T, EndpointSliceList] {
      def apply(t: T): Either[String, EndpointSliceList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.discovery.v1.EndpointSlice]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield EndpointSliceList (
          items = items,
          metadata = metadata
        )
    }
}

