package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** WindowsSecurityContextOptions contain Windows-specific options and credentials. */
final case class WindowsSecurityContextOptions(
  gmsaCredentialSpec : Option[String] = None,
  gmsaCredentialSpecName : Option[String] = None,
  hostProcess : Option[Boolean] = None,
  runAsUserName : Option[String] = None
) {

  /** Returns a new data with gmsaCredentialSpec set to new value */
  def withGmsaCredentialSpec(value: String) : WindowsSecurityContextOptions = copy(gmsaCredentialSpec = Some(value))
  /** if gmsaCredentialSpec has a value, transforms to the result of function*/
  def mapGmsaCredentialSpec(f: String => String) : WindowsSecurityContextOptions = copy(gmsaCredentialSpec = gmsaCredentialSpec.map(f))

  /** Returns a new data with gmsaCredentialSpecName set to new value */
  def withGmsaCredentialSpecName(value: String) : WindowsSecurityContextOptions = copy(gmsaCredentialSpecName = Some(value))
  /** if gmsaCredentialSpecName has a value, transforms to the result of function*/
  def mapGmsaCredentialSpecName(f: String => String) : WindowsSecurityContextOptions = copy(gmsaCredentialSpecName = gmsaCredentialSpecName.map(f))

  /** Returns a new data with hostProcess set to new value */
  def withHostProcess(value: Boolean) : WindowsSecurityContextOptions = copy(hostProcess = Some(value))
  /** if hostProcess has a value, transforms to the result of function*/
  def mapHostProcess(f: Boolean => Boolean) : WindowsSecurityContextOptions = copy(hostProcess = hostProcess.map(f))

  /** Returns a new data with runAsUserName set to new value */
  def withRunAsUserName(value: String) : WindowsSecurityContextOptions = copy(runAsUserName = Some(value))
  /** if runAsUserName has a value, transforms to the result of function*/
  def mapRunAsUserName(f: String => String) : WindowsSecurityContextOptions = copy(runAsUserName = runAsUserName.map(f))
}

object WindowsSecurityContextOptions {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.WindowsSecurityContextOptions, T] = new Encoder[io.k8s.api.core.v1.WindowsSecurityContextOptions, T] {
        def apply(o: io.k8s.api.core.v1.WindowsSecurityContextOptions) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("gmsaCredentialSpec", o.gmsaCredentialSpec)
            .write("gmsaCredentialSpecName", o.gmsaCredentialSpecName)
            .write("hostProcess", o.hostProcess)
            .write("runAsUserName", o.runAsUserName)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, WindowsSecurityContextOptions] = new Decoder[T, WindowsSecurityContextOptions] {
      def apply(t: T): Either[String, WindowsSecurityContextOptions] = for {
          obj <- ObjectReader(t)
          gmsaCredentialSpec <- obj.readOpt[String]("gmsaCredentialSpec")
          gmsaCredentialSpecName <- obj.readOpt[String]("gmsaCredentialSpecName")
          hostProcess <- obj.readOpt[Boolean]("hostProcess")
          runAsUserName <- obj.readOpt[String]("runAsUserName")
      } yield WindowsSecurityContextOptions (
          gmsaCredentialSpec = gmsaCredentialSpec,
          gmsaCredentialSpecName = gmsaCredentialSpecName,
          hostProcess = hostProcess,
          runAsUserName = runAsUserName
        )
    }
}

