package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** Projection that may be projected along with other supported volume types */
final case class VolumeProjection(
  configMap : Option[io.k8s.api.core.v1.ConfigMapProjection] = None,
  downwardAPI : Option[io.k8s.api.core.v1.DownwardAPIProjection] = None,
  secret : Option[io.k8s.api.core.v1.SecretProjection] = None,
  serviceAccountToken : Option[io.k8s.api.core.v1.ServiceAccountTokenProjection] = None
) {

  /** Returns a new data with configMap set to new value */
  def withConfigMap(value: io.k8s.api.core.v1.ConfigMapProjection) : VolumeProjection = copy(configMap = Some(value))
  /** if configMap has a value, transforms to the result of function*/
  def mapConfigMap(f: io.k8s.api.core.v1.ConfigMapProjection => io.k8s.api.core.v1.ConfigMapProjection) : VolumeProjection = copy(configMap = configMap.map(f))

  /** Returns a new data with downwardAPI set to new value */
  def withDownwardAPI(value: io.k8s.api.core.v1.DownwardAPIProjection) : VolumeProjection = copy(downwardAPI = Some(value))
  /** if downwardAPI has a value, transforms to the result of function*/
  def mapDownwardAPI(f: io.k8s.api.core.v1.DownwardAPIProjection => io.k8s.api.core.v1.DownwardAPIProjection) : VolumeProjection = copy(downwardAPI = downwardAPI.map(f))

  /** Returns a new data with secret set to new value */
  def withSecret(value: io.k8s.api.core.v1.SecretProjection) : VolumeProjection = copy(secret = Some(value))
  /** if secret has a value, transforms to the result of function*/
  def mapSecret(f: io.k8s.api.core.v1.SecretProjection => io.k8s.api.core.v1.SecretProjection) : VolumeProjection = copy(secret = secret.map(f))

  /** Returns a new data with serviceAccountToken set to new value */
  def withServiceAccountToken(value: io.k8s.api.core.v1.ServiceAccountTokenProjection) : VolumeProjection = copy(serviceAccountToken = Some(value))
  /** if serviceAccountToken has a value, transforms to the result of function*/
  def mapServiceAccountToken(f: io.k8s.api.core.v1.ServiceAccountTokenProjection => io.k8s.api.core.v1.ServiceAccountTokenProjection) : VolumeProjection = copy(serviceAccountToken = serviceAccountToken.map(f))
}

object VolumeProjection {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.VolumeProjection, T] = new Encoder[io.k8s.api.core.v1.VolumeProjection, T] {
        def apply(o: io.k8s.api.core.v1.VolumeProjection) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("configMap", o.configMap)
            .write("downwardAPI", o.downwardAPI)
            .write("secret", o.secret)
            .write("serviceAccountToken", o.serviceAccountToken)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, VolumeProjection] = new Decoder[T, VolumeProjection] {
      def apply(t: T): Either[String, VolumeProjection] = for {
          obj <- ObjectReader(t)
          configMap <- obj.readOpt[io.k8s.api.core.v1.ConfigMapProjection]("configMap")
          downwardAPI <- obj.readOpt[io.k8s.api.core.v1.DownwardAPIProjection]("downwardAPI")
          secret <- obj.readOpt[io.k8s.api.core.v1.SecretProjection]("secret")
          serviceAccountToken <- obj.readOpt[io.k8s.api.core.v1.ServiceAccountTokenProjection]("serviceAccountToken")
      } yield VolumeProjection (
          configMap = configMap,
          downwardAPI = downwardAPI,
          secret = secret,
          serviceAccountToken = serviceAccountToken
        )
    }
}

