package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** Sysctl defines a kernel parameter to be set */
final case class Sysctl(
  name : String,
  value : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : Sysctl = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : Sysctl = copy(name = f(name))

  /** Returns a new data with value set to new value */
  def withValue(value: String) : Sysctl = copy(value = value)
  /** transforms value to result of function */
  def mapValue(f: String => String) : Sysctl = copy(value = f(value))
}

object Sysctl {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.Sysctl, T] = new Encoder[io.k8s.api.core.v1.Sysctl, T] {
        def apply(o: io.k8s.api.core.v1.Sysctl) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("value", o.value)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, Sysctl] = new Decoder[T, Sysctl] {
      def apply(t: T): Either[String, Sysctl] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
          value <- obj.read[String]("value")
      } yield Sysctl (
          name = name,
          value = value
        )
    }
}

