package io.k8s.api.core.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ResourceQuotaList is a list of ResourceQuota items. */
final case class ResourceQuotaList(
  items : Seq[io.k8s.api.core.v1.ResourceQuota],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "ResourceQuotaList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.core.v1.ResourceQuota]) : ResourceQuotaList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.core.v1.ResourceQuota*) : ResourceQuotaList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.core.v1.ResourceQuota] => Seq[io.k8s.api.core.v1.ResourceQuota]) : ResourceQuotaList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ResourceQuotaList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ResourceQuotaList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ResourceQuotaList.encoder[T].apply(this)
}

object ResourceQuotaList {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.ResourceQuotaList, T] = new Encoder[io.k8s.api.core.v1.ResourceQuotaList, T] {
        def apply(o: io.k8s.api.core.v1.ResourceQuotaList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ResourceQuotaList] = new Decoder[T, ResourceQuotaList] {
      def apply(t: T): Either[String, ResourceQuotaList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.core.v1.ResourceQuota]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield ResourceQuotaList (
          items = items,
          metadata = metadata
        )
    }
}

