package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** Represents a projected volume source */
final case class ProjectedVolumeSource(
  defaultMode : Option[Int] = None,
  sources : Option[Seq[io.k8s.api.core.v1.VolumeProjection]] = None
) {

  /** Returns a new data with defaultMode set to new value */
  def withDefaultMode(value: Int) : ProjectedVolumeSource = copy(defaultMode = Some(value))
  /** if defaultMode has a value, transforms to the result of function*/
  def mapDefaultMode(f: Int => Int) : ProjectedVolumeSource = copy(defaultMode = defaultMode.map(f))

  /** Returns a new data with sources set to new value */
  def withSources(value: Seq[io.k8s.api.core.v1.VolumeProjection]) : ProjectedVolumeSource = copy(sources = Some(value))
  /** Appends new values to sources */
  def addSources(newValues: io.k8s.api.core.v1.VolumeProjection*) : ProjectedVolumeSource = copy(sources = Some(sources.fold(newValues)(_ ++ newValues)))
  /** if sources has a value, transforms to the result of function*/
  def mapSources(f: Seq[io.k8s.api.core.v1.VolumeProjection] => Seq[io.k8s.api.core.v1.VolumeProjection]) : ProjectedVolumeSource = copy(sources = sources.map(f))
}

object ProjectedVolumeSource {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.ProjectedVolumeSource, T] = new Encoder[io.k8s.api.core.v1.ProjectedVolumeSource, T] {
        def apply(o: io.k8s.api.core.v1.ProjectedVolumeSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("defaultMode", o.defaultMode)
            .write("sources", o.sources)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ProjectedVolumeSource] = new Decoder[T, ProjectedVolumeSource] {
      def apply(t: T): Either[String, ProjectedVolumeSource] = for {
          obj <- ObjectReader(t)
          defaultMode <- obj.readOpt[Int]("defaultMode")
          sources <- obj.readOpt[Seq[io.k8s.api.core.v1.VolumeProjection]]("sources")
      } yield ProjectedVolumeSource (
          defaultMode = defaultMode,
          sources = sources
        )
    }
}

