package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** Represents a Photon Controller persistent disk resource. */
final case class PhotonPersistentDiskVolumeSource(
  pdID : String,
  fsType : Option[String] = None
) {

  /** Returns a new data with pdID set to new value */
  def withPdID(value: String) : PhotonPersistentDiskVolumeSource = copy(pdID = value)
  /** transforms pdID to result of function */
  def mapPdID(f: String => String) : PhotonPersistentDiskVolumeSource = copy(pdID = f(pdID))

  /** Returns a new data with fsType set to new value */
  def withFsType(value: String) : PhotonPersistentDiskVolumeSource = copy(fsType = Some(value))
  /** if fsType has a value, transforms to the result of function*/
  def mapFsType(f: String => String) : PhotonPersistentDiskVolumeSource = copy(fsType = fsType.map(f))
}

object PhotonPersistentDiskVolumeSource {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource, T] = new Encoder[io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource, T] {
        def apply(o: io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("pdID", o.pdID)
            .write("fsType", o.fsType)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, PhotonPersistentDiskVolumeSource] = new Decoder[T, PhotonPersistentDiskVolumeSource] {
      def apply(t: T): Either[String, PhotonPersistentDiskVolumeSource] = for {
          obj <- ObjectReader(t)
          pdID <- obj.read[String]("pdID")
          fsType <- obj.readOpt[String]("fsType")
      } yield PhotonPersistentDiskVolumeSource (
          pdID = pdID,
          fsType = fsType
        )
    }
}

