package io.k8s.api.core.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** PersistentVolumeList is a list of PersistentVolume items. */
final case class PersistentVolumeList(
  items : Seq[io.k8s.api.core.v1.PersistentVolume],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "PersistentVolumeList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.core.v1.PersistentVolume]) : PersistentVolumeList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.core.v1.PersistentVolume*) : PersistentVolumeList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.core.v1.PersistentVolume] => Seq[io.k8s.api.core.v1.PersistentVolume]) : PersistentVolumeList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : PersistentVolumeList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : PersistentVolumeList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = PersistentVolumeList.encoder[T].apply(this)
}

object PersistentVolumeList {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.PersistentVolumeList, T] = new Encoder[io.k8s.api.core.v1.PersistentVolumeList, T] {
        def apply(o: io.k8s.api.core.v1.PersistentVolumeList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, PersistentVolumeList] = new Decoder[T, PersistentVolumeList] {
      def apply(t: T): Either[String, PersistentVolumeList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.core.v1.PersistentVolume]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield PersistentVolumeList (
          items = items,
          metadata = metadata
        )
    }
}

