package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace. */
final case class LocalObjectReference(
  name : Option[String] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : LocalObjectReference = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : LocalObjectReference = copy(name = name.map(f))
}

object LocalObjectReference {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.LocalObjectReference, T] = new Encoder[io.k8s.api.core.v1.LocalObjectReference, T] {
        def apply(o: io.k8s.api.core.v1.LocalObjectReference) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, LocalObjectReference] = new Decoder[T, LocalObjectReference] {
      def apply(t: T): Either[String, LocalObjectReference] = for {
          obj <- ObjectReader(t)
          name <- obj.readOpt[String]("name")
      } yield LocalObjectReference (
          name = name
        )
    }
}

