package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** LoadBalancerStatus represents the status of a load-balancer. */
final case class LoadBalancerStatus(
  ingress : Option[Seq[io.k8s.api.core.v1.LoadBalancerIngress]] = None
) {

  /** Returns a new data with ingress set to new value */
  def withIngress(value: Seq[io.k8s.api.core.v1.LoadBalancerIngress]) : LoadBalancerStatus = copy(ingress = Some(value))
  /** Appends new values to ingress */
  def addIngress(newValues: io.k8s.api.core.v1.LoadBalancerIngress*) : LoadBalancerStatus = copy(ingress = Some(ingress.fold(newValues)(_ ++ newValues)))
  /** if ingress has a value, transforms to the result of function*/
  def mapIngress(f: Seq[io.k8s.api.core.v1.LoadBalancerIngress] => Seq[io.k8s.api.core.v1.LoadBalancerIngress]) : LoadBalancerStatus = copy(ingress = ingress.map(f))
}

object LoadBalancerStatus {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.LoadBalancerStatus, T] = new Encoder[io.k8s.api.core.v1.LoadBalancerStatus, T] {
        def apply(o: io.k8s.api.core.v1.LoadBalancerStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("ingress", o.ingress)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, LoadBalancerStatus] = new Decoder[T, LoadBalancerStatus] {
      def apply(t: T): Either[String, LoadBalancerStatus] = for {
          obj <- ObjectReader(t)
          ingress <- obj.readOpt[Seq[io.k8s.api.core.v1.LoadBalancerIngress]]("ingress")
      } yield LoadBalancerStatus (
          ingress = ingress
        )
    }
}

