package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** Represents a Flocker volume mounted by the Flocker agent. One and only one of datasetName and datasetUUID should be set. Flocker volumes do not support ownership management or SELinux relabeling. */
final case class FlockerVolumeSource(
  datasetName : Option[String] = None,
  datasetUUID : Option[String] = None
) {

  /** Returns a new data with datasetName set to new value */
  def withDatasetName(value: String) : FlockerVolumeSource = copy(datasetName = Some(value))
  /** if datasetName has a value, transforms to the result of function*/
  def mapDatasetName(f: String => String) : FlockerVolumeSource = copy(datasetName = datasetName.map(f))

  /** Returns a new data with datasetUUID set to new value */
  def withDatasetUUID(value: String) : FlockerVolumeSource = copy(datasetUUID = Some(value))
  /** if datasetUUID has a value, transforms to the result of function*/
  def mapDatasetUUID(f: String => String) : FlockerVolumeSource = copy(datasetUUID = datasetUUID.map(f))
}

object FlockerVolumeSource {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.FlockerVolumeSource, T] = new Encoder[io.k8s.api.core.v1.FlockerVolumeSource, T] {
        def apply(o: io.k8s.api.core.v1.FlockerVolumeSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("datasetName", o.datasetName)
            .write("datasetUUID", o.datasetUUID)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, FlockerVolumeSource] = new Decoder[T, FlockerVolumeSource] {
      def apply(t: T): Either[String, FlockerVolumeSource] = for {
          obj <- ObjectReader(t)
          datasetName <- obj.readOpt[String]("datasetName")
          datasetUUID <- obj.readOpt[String]("datasetUUID")
      } yield FlockerVolumeSource (
          datasetName = datasetName,
          datasetUUID = datasetUUID
        )
    }
}

