package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** DaemonEndpoint contains information about a single Daemon endpoint. */
final case class DaemonEndpoint(
  Port : Int
) {

  /** Returns a new data with Port set to new value */
  def withPort(value: Int) : DaemonEndpoint = copy(Port = value)
  /** transforms Port to result of function */
  def mapPort(f: Int => Int) : DaemonEndpoint = copy(Port = f(Port))
}

object DaemonEndpoint {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.DaemonEndpoint, T] = new Encoder[io.k8s.api.core.v1.DaemonEndpoint, T] {
        def apply(o: io.k8s.api.core.v1.DaemonEndpoint) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("Port", o.Port)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, DaemonEndpoint] = new Decoder[T, DaemonEndpoint] {
      def apply(t: T): Either[String, DaemonEndpoint] = for {
          obj <- ObjectReader(t)
          Port <- obj.read[Int]("Port")
      } yield DaemonEndpoint (
          Port = Port
        )
    }
}

