package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** ContainerStateRunning is a running state of a container. */
final case class ContainerStateRunning(
  startedAt : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None
) {

  /** Returns a new data with startedAt set to new value */
  def withStartedAt(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : ContainerStateRunning = copy(startedAt = Some(value))
  /** if startedAt has a value, transforms to the result of function*/
  def mapStartedAt(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : ContainerStateRunning = copy(startedAt = startedAt.map(f))
}

object ContainerStateRunning {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.ContainerStateRunning, T] = new Encoder[io.k8s.api.core.v1.ContainerStateRunning, T] {
        def apply(o: io.k8s.api.core.v1.ContainerStateRunning) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("startedAt", o.startedAt)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ContainerStateRunning] = new Decoder[T, ContainerStateRunning] {
      def apply(t: T): Either[String, ContainerStateRunning] = for {
          obj <- ObjectReader(t)
          startedAt <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.Time]("startedAt")
      } yield ContainerStateRunning (
          startedAt = startedAt
        )
    }
}

