package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** Represents storage that is managed by an external CSI volume driver (Beta feature) */
final case class CSIPersistentVolumeSource(
  volumeHandle : String,
  driver : String,
  nodeStageSecretRef : Option[io.k8s.api.core.v1.SecretReference] = None,
  readOnly : Option[Boolean] = None,
  fsType : Option[String] = None,
  controllerPublishSecretRef : Option[io.k8s.api.core.v1.SecretReference] = None,
  volumeAttributes : Option[Map[String, String]] = None,
  controllerExpandSecretRef : Option[io.k8s.api.core.v1.SecretReference] = None,
  nodeExpandSecretRef : Option[io.k8s.api.core.v1.SecretReference] = None,
  nodePublishSecretRef : Option[io.k8s.api.core.v1.SecretReference] = None
) {

  /** Returns a new data with volumeHandle set to new value */
  def withVolumeHandle(value: String) : CSIPersistentVolumeSource = copy(volumeHandle = value)
  /** transforms volumeHandle to result of function */
  def mapVolumeHandle(f: String => String) : CSIPersistentVolumeSource = copy(volumeHandle = f(volumeHandle))

  /** Returns a new data with driver set to new value */
  def withDriver(value: String) : CSIPersistentVolumeSource = copy(driver = value)
  /** transforms driver to result of function */
  def mapDriver(f: String => String) : CSIPersistentVolumeSource = copy(driver = f(driver))

  /** Returns a new data with nodeStageSecretRef set to new value */
  def withNodeStageSecretRef(value: io.k8s.api.core.v1.SecretReference) : CSIPersistentVolumeSource = copy(nodeStageSecretRef = Some(value))
  /** if nodeStageSecretRef has a value, transforms to the result of function*/
  def mapNodeStageSecretRef(f: io.k8s.api.core.v1.SecretReference => io.k8s.api.core.v1.SecretReference) : CSIPersistentVolumeSource = copy(nodeStageSecretRef = nodeStageSecretRef.map(f))

  /** Returns a new data with readOnly set to new value */
  def withReadOnly(value: Boolean) : CSIPersistentVolumeSource = copy(readOnly = Some(value))
  /** if readOnly has a value, transforms to the result of function*/
  def mapReadOnly(f: Boolean => Boolean) : CSIPersistentVolumeSource = copy(readOnly = readOnly.map(f))

  /** Returns a new data with fsType set to new value */
  def withFsType(value: String) : CSIPersistentVolumeSource = copy(fsType = Some(value))
  /** if fsType has a value, transforms to the result of function*/
  def mapFsType(f: String => String) : CSIPersistentVolumeSource = copy(fsType = fsType.map(f))

  /** Returns a new data with controllerPublishSecretRef set to new value */
  def withControllerPublishSecretRef(value: io.k8s.api.core.v1.SecretReference) : CSIPersistentVolumeSource = copy(controllerPublishSecretRef = Some(value))
  /** if controllerPublishSecretRef has a value, transforms to the result of function*/
  def mapControllerPublishSecretRef(f: io.k8s.api.core.v1.SecretReference => io.k8s.api.core.v1.SecretReference) : CSIPersistentVolumeSource = copy(controllerPublishSecretRef = controllerPublishSecretRef.map(f))

  /** Returns a new data with volumeAttributes set to new value */
  def withVolumeAttributes(value: Map[String, String]) : CSIPersistentVolumeSource = copy(volumeAttributes = Some(value))
  /** Adds new values to volumeAttributes */
  def addVolumeAttributes(newValues: (String, String)*) : CSIPersistentVolumeSource = copy(volumeAttributes = Some(volumeAttributes.fold(newValues.toMap)(_ ++ newValues)))
  /** if volumeAttributes has a value, transforms to the result of function*/
  def mapVolumeAttributes(f: Map[String, String] => Map[String, String]) : CSIPersistentVolumeSource = copy(volumeAttributes = volumeAttributes.map(f))

  /** Returns a new data with controllerExpandSecretRef set to new value */
  def withControllerExpandSecretRef(value: io.k8s.api.core.v1.SecretReference) : CSIPersistentVolumeSource = copy(controllerExpandSecretRef = Some(value))
  /** if controllerExpandSecretRef has a value, transforms to the result of function*/
  def mapControllerExpandSecretRef(f: io.k8s.api.core.v1.SecretReference => io.k8s.api.core.v1.SecretReference) : CSIPersistentVolumeSource = copy(controllerExpandSecretRef = controllerExpandSecretRef.map(f))

  /** Returns a new data with nodeExpandSecretRef set to new value */
  def withNodeExpandSecretRef(value: io.k8s.api.core.v1.SecretReference) : CSIPersistentVolumeSource = copy(nodeExpandSecretRef = Some(value))
  /** if nodeExpandSecretRef has a value, transforms to the result of function*/
  def mapNodeExpandSecretRef(f: io.k8s.api.core.v1.SecretReference => io.k8s.api.core.v1.SecretReference) : CSIPersistentVolumeSource = copy(nodeExpandSecretRef = nodeExpandSecretRef.map(f))

  /** Returns a new data with nodePublishSecretRef set to new value */
  def withNodePublishSecretRef(value: io.k8s.api.core.v1.SecretReference) : CSIPersistentVolumeSource = copy(nodePublishSecretRef = Some(value))
  /** if nodePublishSecretRef has a value, transforms to the result of function*/
  def mapNodePublishSecretRef(f: io.k8s.api.core.v1.SecretReference => io.k8s.api.core.v1.SecretReference) : CSIPersistentVolumeSource = copy(nodePublishSecretRef = nodePublishSecretRef.map(f))
}

object CSIPersistentVolumeSource {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.CSIPersistentVolumeSource, T] = new Encoder[io.k8s.api.core.v1.CSIPersistentVolumeSource, T] {
        def apply(o: io.k8s.api.core.v1.CSIPersistentVolumeSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("volumeHandle", o.volumeHandle)
            .write("driver", o.driver)
            .write("nodeStageSecretRef", o.nodeStageSecretRef)
            .write("readOnly", o.readOnly)
            .write("fsType", o.fsType)
            .write("controllerPublishSecretRef", o.controllerPublishSecretRef)
            .write("volumeAttributes", o.volumeAttributes)
            .write("controllerExpandSecretRef", o.controllerExpandSecretRef)
            .write("nodeExpandSecretRef", o.nodeExpandSecretRef)
            .write("nodePublishSecretRef", o.nodePublishSecretRef)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, CSIPersistentVolumeSource] = new Decoder[T, CSIPersistentVolumeSource] {
      def apply(t: T): Either[String, CSIPersistentVolumeSource] = for {
          obj <- ObjectReader(t)
          volumeHandle <- obj.read[String]("volumeHandle")
          driver <- obj.read[String]("driver")
          nodeStageSecretRef <- obj.readOpt[io.k8s.api.core.v1.SecretReference]("nodeStageSecretRef")
          readOnly <- obj.readOpt[Boolean]("readOnly")
          fsType <- obj.readOpt[String]("fsType")
          controllerPublishSecretRef <- obj.readOpt[io.k8s.api.core.v1.SecretReference]("controllerPublishSecretRef")
          volumeAttributes <- obj.readOpt[Map[String, String]]("volumeAttributes")
          controllerExpandSecretRef <- obj.readOpt[io.k8s.api.core.v1.SecretReference]("controllerExpandSecretRef")
          nodeExpandSecretRef <- obj.readOpt[io.k8s.api.core.v1.SecretReference]("nodeExpandSecretRef")
          nodePublishSecretRef <- obj.readOpt[io.k8s.api.core.v1.SecretReference]("nodePublishSecretRef")
      } yield CSIPersistentVolumeSource (
          volumeHandle = volumeHandle,
          driver = driver,
          nodeStageSecretRef = nodeStageSecretRef,
          readOnly = readOnly,
          fsType = fsType,
          controllerPublishSecretRef = controllerPublishSecretRef,
          volumeAttributes = volumeAttributes,
          controllerExpandSecretRef = controllerExpandSecretRef,
          nodeExpandSecretRef = nodeExpandSecretRef,
          nodePublishSecretRef = nodePublishSecretRef
        )
    }
}

