package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** Affinity is a group of affinity scheduling rules. */
final case class Affinity(
  nodeAffinity : Option[io.k8s.api.core.v1.NodeAffinity] = None,
  podAffinity : Option[io.k8s.api.core.v1.PodAffinity] = None,
  podAntiAffinity : Option[io.k8s.api.core.v1.PodAntiAffinity] = None
) {

  /** Returns a new data with nodeAffinity set to new value */
  def withNodeAffinity(value: io.k8s.api.core.v1.NodeAffinity) : Affinity = copy(nodeAffinity = Some(value))
  /** if nodeAffinity has a value, transforms to the result of function*/
  def mapNodeAffinity(f: io.k8s.api.core.v1.NodeAffinity => io.k8s.api.core.v1.NodeAffinity) : Affinity = copy(nodeAffinity = nodeAffinity.map(f))

  /** Returns a new data with podAffinity set to new value */
  def withPodAffinity(value: io.k8s.api.core.v1.PodAffinity) : Affinity = copy(podAffinity = Some(value))
  /** if podAffinity has a value, transforms to the result of function*/
  def mapPodAffinity(f: io.k8s.api.core.v1.PodAffinity => io.k8s.api.core.v1.PodAffinity) : Affinity = copy(podAffinity = podAffinity.map(f))

  /** Returns a new data with podAntiAffinity set to new value */
  def withPodAntiAffinity(value: io.k8s.api.core.v1.PodAntiAffinity) : Affinity = copy(podAntiAffinity = Some(value))
  /** if podAntiAffinity has a value, transforms to the result of function*/
  def mapPodAntiAffinity(f: io.k8s.api.core.v1.PodAntiAffinity => io.k8s.api.core.v1.PodAntiAffinity) : Affinity = copy(podAntiAffinity = podAntiAffinity.map(f))
}

object Affinity {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.Affinity, T] = new Encoder[io.k8s.api.core.v1.Affinity, T] {
        def apply(o: io.k8s.api.core.v1.Affinity) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("nodeAffinity", o.nodeAffinity)
            .write("podAffinity", o.podAffinity)
            .write("podAntiAffinity", o.podAntiAffinity)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, Affinity] = new Decoder[T, Affinity] {
      def apply(t: T): Either[String, Affinity] = for {
          obj <- ObjectReader(t)
          nodeAffinity <- obj.readOpt[io.k8s.api.core.v1.NodeAffinity]("nodeAffinity")
          podAffinity <- obj.readOpt[io.k8s.api.core.v1.PodAffinity]("podAffinity")
          podAntiAffinity <- obj.readOpt[io.k8s.api.core.v1.PodAntiAffinity]("podAntiAffinity")
      } yield Affinity (
          nodeAffinity = nodeAffinity,
          podAffinity = podAffinity,
          podAntiAffinity = podAntiAffinity
        )
    }
}

