package io.k8s.api.batch.v1

import dev.hnaderi.k8s.utils._

/** PodFailurePolicyOnPodConditionsPattern describes a pattern for matching an actual pod condition type. */
final case class PodFailurePolicyOnPodConditionsPattern(
  status : String,
  `type` : String
) {

  /** Returns a new data with status set to new value */
  def withStatus(value: String) : PodFailurePolicyOnPodConditionsPattern = copy(status = value)
  /** transforms status to result of function */
  def mapStatus(f: String => String) : PodFailurePolicyOnPodConditionsPattern = copy(status = f(status))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : PodFailurePolicyOnPodConditionsPattern = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : PodFailurePolicyOnPodConditionsPattern = copy(`type` = f(`type`))
}

object PodFailurePolicyOnPodConditionsPattern {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.batch.v1.PodFailurePolicyOnPodConditionsPattern, T] = new Encoder[io.k8s.api.batch.v1.PodFailurePolicyOnPodConditionsPattern, T] {
        def apply(o: io.k8s.api.batch.v1.PodFailurePolicyOnPodConditionsPattern) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("type", o.`type`)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, PodFailurePolicyOnPodConditionsPattern] = new Decoder[T, PodFailurePolicyOnPodConditionsPattern] {
      def apply(t: T): Either[String, PodFailurePolicyOnPodConditionsPattern] = for {
          obj <- ObjectReader(t)
          status <- obj.read[String]("status")
          `type` <- obj.read[String]("type")
      } yield PodFailurePolicyOnPodConditionsPattern (
          status = status,
          `type` = `type`
        )
    }
}

