package io.k8s.api.autoscaling.v2

import dev.hnaderi.k8s.utils._

/** ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object). */
final case class ObjectMetricSource(
  describedObject : io.k8s.api.autoscaling.v2.CrossVersionObjectReference,
  metric : io.k8s.api.autoscaling.v2.MetricIdentifier,
  target : io.k8s.api.autoscaling.v2.MetricTarget
) {

  /** Returns a new data with describedObject set to new value */
  def withDescribedObject(value: io.k8s.api.autoscaling.v2.CrossVersionObjectReference) : ObjectMetricSource = copy(describedObject = value)
  /** transforms describedObject to result of function */
  def mapDescribedObject(f: io.k8s.api.autoscaling.v2.CrossVersionObjectReference => io.k8s.api.autoscaling.v2.CrossVersionObjectReference) : ObjectMetricSource = copy(describedObject = f(describedObject))

  /** Returns a new data with metric set to new value */
  def withMetric(value: io.k8s.api.autoscaling.v2.MetricIdentifier) : ObjectMetricSource = copy(metric = value)
  /** transforms metric to result of function */
  def mapMetric(f: io.k8s.api.autoscaling.v2.MetricIdentifier => io.k8s.api.autoscaling.v2.MetricIdentifier) : ObjectMetricSource = copy(metric = f(metric))

  /** Returns a new data with target set to new value */
  def withTarget(value: io.k8s.api.autoscaling.v2.MetricTarget) : ObjectMetricSource = copy(target = value)
  /** transforms target to result of function */
  def mapTarget(f: io.k8s.api.autoscaling.v2.MetricTarget => io.k8s.api.autoscaling.v2.MetricTarget) : ObjectMetricSource = copy(target = f(target))
}

object ObjectMetricSource {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.autoscaling.v2.ObjectMetricSource, T] = new Encoder[io.k8s.api.autoscaling.v2.ObjectMetricSource, T] {
        def apply(o: io.k8s.api.autoscaling.v2.ObjectMetricSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("describedObject", o.describedObject)
            .write("metric", o.metric)
            .write("target", o.target)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ObjectMetricSource] = new Decoder[T, ObjectMetricSource] {
      def apply(t: T): Either[String, ObjectMetricSource] = for {
          obj <- ObjectReader(t)
          describedObject <- obj.read[io.k8s.api.autoscaling.v2.CrossVersionObjectReference]("describedObject")
          metric <- obj.read[io.k8s.api.autoscaling.v2.MetricIdentifier]("metric")
          target <- obj.read[io.k8s.api.autoscaling.v2.MetricTarget]("target")
      } yield ObjectMetricSource (
          describedObject = describedObject,
          metric = metric,
          target = target
        )
    }
}

