package io.k8s.api.autoscaling.v2

import dev.hnaderi.k8s.utils._

/** MetricStatus describes the last-read state of a single metric. */
final case class MetricStatus(
  `type` : String,
  `object` : Option[io.k8s.api.autoscaling.v2.ObjectMetricStatus] = None,
  external : Option[io.k8s.api.autoscaling.v2.ExternalMetricStatus] = None,
  containerResource : Option[io.k8s.api.autoscaling.v2.ContainerResourceMetricStatus] = None,
  resource : Option[io.k8s.api.autoscaling.v2.ResourceMetricStatus] = None,
  pods : Option[io.k8s.api.autoscaling.v2.PodsMetricStatus] = None
) {

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : MetricStatus = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : MetricStatus = copy(`type` = f(`type`))

  /** Returns a new data with `object` set to new value */
  def withObject(value: io.k8s.api.autoscaling.v2.ObjectMetricStatus) : MetricStatus = copy(`object` = Some(value))
  /** if `object` has a value, transforms to the result of function*/
  def mapObject(f: io.k8s.api.autoscaling.v2.ObjectMetricStatus => io.k8s.api.autoscaling.v2.ObjectMetricStatus) : MetricStatus = copy(`object` = `object`.map(f))

  /** Returns a new data with external set to new value */
  def withExternal(value: io.k8s.api.autoscaling.v2.ExternalMetricStatus) : MetricStatus = copy(external = Some(value))
  /** if external has a value, transforms to the result of function*/
  def mapExternal(f: io.k8s.api.autoscaling.v2.ExternalMetricStatus => io.k8s.api.autoscaling.v2.ExternalMetricStatus) : MetricStatus = copy(external = external.map(f))

  /** Returns a new data with containerResource set to new value */
  def withContainerResource(value: io.k8s.api.autoscaling.v2.ContainerResourceMetricStatus) : MetricStatus = copy(containerResource = Some(value))
  /** if containerResource has a value, transforms to the result of function*/
  def mapContainerResource(f: io.k8s.api.autoscaling.v2.ContainerResourceMetricStatus => io.k8s.api.autoscaling.v2.ContainerResourceMetricStatus) : MetricStatus = copy(containerResource = containerResource.map(f))

  /** Returns a new data with resource set to new value */
  def withResource(value: io.k8s.api.autoscaling.v2.ResourceMetricStatus) : MetricStatus = copy(resource = Some(value))
  /** if resource has a value, transforms to the result of function*/
  def mapResource(f: io.k8s.api.autoscaling.v2.ResourceMetricStatus => io.k8s.api.autoscaling.v2.ResourceMetricStatus) : MetricStatus = copy(resource = resource.map(f))

  /** Returns a new data with pods set to new value */
  def withPods(value: io.k8s.api.autoscaling.v2.PodsMetricStatus) : MetricStatus = copy(pods = Some(value))
  /** if pods has a value, transforms to the result of function*/
  def mapPods(f: io.k8s.api.autoscaling.v2.PodsMetricStatus => io.k8s.api.autoscaling.v2.PodsMetricStatus) : MetricStatus = copy(pods = pods.map(f))
}

object MetricStatus {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.autoscaling.v2.MetricStatus, T] = new Encoder[io.k8s.api.autoscaling.v2.MetricStatus, T] {
        def apply(o: io.k8s.api.autoscaling.v2.MetricStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("type", o.`type`)
            .write("object", o.`object`)
            .write("external", o.external)
            .write("containerResource", o.containerResource)
            .write("resource", o.resource)
            .write("pods", o.pods)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, MetricStatus] = new Decoder[T, MetricStatus] {
      def apply(t: T): Either[String, MetricStatus] = for {
          obj <- ObjectReader(t)
          `type` <- obj.read[String]("type")
          `object` <- obj.readOpt[io.k8s.api.autoscaling.v2.ObjectMetricStatus]("object")
          external <- obj.readOpt[io.k8s.api.autoscaling.v2.ExternalMetricStatus]("external")
          containerResource <- obj.readOpt[io.k8s.api.autoscaling.v2.ContainerResourceMetricStatus]("containerResource")
          resource <- obj.readOpt[io.k8s.api.autoscaling.v2.ResourceMetricStatus]("resource")
          pods <- obj.readOpt[io.k8s.api.autoscaling.v2.PodsMetricStatus]("pods")
      } yield MetricStatus (
          `type` = `type`,
          `object` = `object`,
          external = external,
          containerResource = containerResource,
          resource = resource,
          pods = pods
        )
    }
}

