package io.k8s.api.autoscaling.v2

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified. */
final case class HorizontalPodAutoscaler(
  status : Option[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerStatus] = None,
  spec : Option[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("autoscaling", "HorizontalPodAutoscaler", "v2")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerStatus) : HorizontalPodAutoscaler = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerStatus => io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerStatus) : HorizontalPodAutoscaler = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerSpec) : HorizontalPodAutoscaler = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerSpec => io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerSpec) : HorizontalPodAutoscaler = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : HorizontalPodAutoscaler = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : HorizontalPodAutoscaler = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = HorizontalPodAutoscaler.encoder[T].apply(this)
}

object HorizontalPodAutoscaler {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.autoscaling.v2.HorizontalPodAutoscaler, T] = new Encoder[io.k8s.api.autoscaling.v2.HorizontalPodAutoscaler, T] {
        def apply(o: io.k8s.api.autoscaling.v2.HorizontalPodAutoscaler) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, HorizontalPodAutoscaler] = new Decoder[T, HorizontalPodAutoscaler] {
      def apply(t: T): Either[String, HorizontalPodAutoscaler] = for {
          obj <- ObjectReader(t)
          status <- obj.readOpt[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerStatus]("status")
          spec <- obj.readOpt[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerSpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield HorizontalPodAutoscaler (
          status = status,
          spec = spec,
          metadata = metadata
        )
    }
}

