package io.k8s.api.authorization.v1

import dev.hnaderi.k8s.utils._

/** NonResourceAttributes includes the authorization attributes available for non-resource requests to the Authorizer interface */
final case class NonResourceAttributes(
  path : Option[String] = None,
  verb : Option[String] = None
) {

  /** Returns a new data with path set to new value */
  def withPath(value: String) : NonResourceAttributes = copy(path = Some(value))
  /** if path has a value, transforms to the result of function*/
  def mapPath(f: String => String) : NonResourceAttributes = copy(path = path.map(f))

  /** Returns a new data with verb set to new value */
  def withVerb(value: String) : NonResourceAttributes = copy(verb = Some(value))
  /** if verb has a value, transforms to the result of function*/
  def mapVerb(f: String => String) : NonResourceAttributes = copy(verb = verb.map(f))
}

object NonResourceAttributes {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.authorization.v1.NonResourceAttributes, T] = new Encoder[io.k8s.api.authorization.v1.NonResourceAttributes, T] {
        def apply(o: io.k8s.api.authorization.v1.NonResourceAttributes) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("path", o.path)
            .write("verb", o.verb)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, NonResourceAttributes] = new Decoder[T, NonResourceAttributes] {
      def apply(t: T): Either[String, NonResourceAttributes] = for {
          obj <- ObjectReader(t)
          path <- obj.readOpt[String]("path")
          verb <- obj.readOpt[String]("verb")
      } yield NonResourceAttributes (
          path = path,
          verb = verb
        )
    }
}

