package io.k8s.api.apps.v1

import dev.hnaderi.k8s.utils._

/** StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy. */
final case class StatefulSetUpdateStrategy(
  rollingUpdate : Option[io.k8s.api.apps.v1.RollingUpdateStatefulSetStrategy] = None,
  `type` : Option[String] = None
) {

  /** Returns a new data with rollingUpdate set to new value */
  def withRollingUpdate(value: io.k8s.api.apps.v1.RollingUpdateStatefulSetStrategy) : StatefulSetUpdateStrategy = copy(rollingUpdate = Some(value))
  /** if rollingUpdate has a value, transforms to the result of function*/
  def mapRollingUpdate(f: io.k8s.api.apps.v1.RollingUpdateStatefulSetStrategy => io.k8s.api.apps.v1.RollingUpdateStatefulSetStrategy) : StatefulSetUpdateStrategy = copy(rollingUpdate = rollingUpdate.map(f))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : StatefulSetUpdateStrategy = copy(`type` = Some(value))
  /** if `type` has a value, transforms to the result of function*/
  def mapType(f: String => String) : StatefulSetUpdateStrategy = copy(`type` = `type`.map(f))
}

object StatefulSetUpdateStrategy {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.apps.v1.StatefulSetUpdateStrategy, T] = new Encoder[io.k8s.api.apps.v1.StatefulSetUpdateStrategy, T] {
        def apply(o: io.k8s.api.apps.v1.StatefulSetUpdateStrategy) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("rollingUpdate", o.rollingUpdate)
            .write("type", o.`type`)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, StatefulSetUpdateStrategy] = new Decoder[T, StatefulSetUpdateStrategy] {
      def apply(t: T): Either[String, StatefulSetUpdateStrategy] = for {
          obj <- ObjectReader(t)
          rollingUpdate <- obj.readOpt[io.k8s.api.apps.v1.RollingUpdateStatefulSetStrategy]("rollingUpdate")
          `type` <- obj.readOpt[String]("type")
      } yield StatefulSetUpdateStrategy (
          rollingUpdate = rollingUpdate,
          `type` = `type`
        )
    }
}

