package io.k8s.api.apps.v1

import dev.hnaderi.k8s.utils._

/** Spec to control the desired behavior of daemon set rolling update. */
final case class RollingUpdateDaemonSet(
  maxSurge : Option[io.k8s.apimachinery.pkg.util.intstr.IntOrString] = None,
  maxUnavailable : Option[io.k8s.apimachinery.pkg.util.intstr.IntOrString] = None
) {

  /** Returns a new data with maxSurge set to new value */
  def withMaxSurge(value: io.k8s.apimachinery.pkg.util.intstr.IntOrString) : RollingUpdateDaemonSet = copy(maxSurge = Some(value))
  /** if maxSurge has a value, transforms to the result of function*/
  def mapMaxSurge(f: io.k8s.apimachinery.pkg.util.intstr.IntOrString => io.k8s.apimachinery.pkg.util.intstr.IntOrString) : RollingUpdateDaemonSet = copy(maxSurge = maxSurge.map(f))

  /** Returns a new data with maxUnavailable set to new value */
  def withMaxUnavailable(value: io.k8s.apimachinery.pkg.util.intstr.IntOrString) : RollingUpdateDaemonSet = copy(maxUnavailable = Some(value))
  /** if maxUnavailable has a value, transforms to the result of function*/
  def mapMaxUnavailable(f: io.k8s.apimachinery.pkg.util.intstr.IntOrString => io.k8s.apimachinery.pkg.util.intstr.IntOrString) : RollingUpdateDaemonSet = copy(maxUnavailable = maxUnavailable.map(f))
}

object RollingUpdateDaemonSet {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.apps.v1.RollingUpdateDaemonSet, T] = new Encoder[io.k8s.api.apps.v1.RollingUpdateDaemonSet, T] {
        def apply(o: io.k8s.api.apps.v1.RollingUpdateDaemonSet) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("maxSurge", o.maxSurge)
            .write("maxUnavailable", o.maxUnavailable)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, RollingUpdateDaemonSet] = new Decoder[T, RollingUpdateDaemonSet] {
      def apply(t: T): Either[String, RollingUpdateDaemonSet] = for {
          obj <- ObjectReader(t)
          maxSurge <- obj.readOpt[io.k8s.apimachinery.pkg.util.intstr.IntOrString]("maxSurge")
          maxUnavailable <- obj.readOpt[io.k8s.apimachinery.pkg.util.intstr.IntOrString]("maxUnavailable")
      } yield RollingUpdateDaemonSet (
          maxSurge = maxSurge,
          maxUnavailable = maxUnavailable
        )
    }
}

