package io.k8s.api.admissionregistration.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ValidatingWebhookConfigurationList is a list of ValidatingWebhookConfiguration. */
final case class ValidatingWebhookConfigurationList(
  items : Seq[io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("admissionregistration.k8s.io", "ValidatingWebhookConfigurationList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration]) : ValidatingWebhookConfigurationList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration*) : ValidatingWebhookConfigurationList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration] => Seq[io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration]) : ValidatingWebhookConfigurationList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ValidatingWebhookConfigurationList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ValidatingWebhookConfigurationList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ValidatingWebhookConfigurationList.encoder[T].apply(this)
}

object ValidatingWebhookConfigurationList {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.admissionregistration.v1.ValidatingWebhookConfigurationList, T] = new Encoder[io.k8s.api.admissionregistration.v1.ValidatingWebhookConfigurationList, T] {
        def apply(o: io.k8s.api.admissionregistration.v1.ValidatingWebhookConfigurationList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ValidatingWebhookConfigurationList] = new Decoder[T, ValidatingWebhookConfigurationList] {
      def apply(t: T): Either[String, ValidatingWebhookConfigurationList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield ValidatingWebhookConfigurationList (
          items = items,
          metadata = metadata
        )
    }
}

