package io.k8s.api.admissionregistration.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** MutatingWebhookConfigurationList is a list of MutatingWebhookConfiguration. */
final case class MutatingWebhookConfigurationList(
  items : Seq[io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("admissionregistration.k8s.io", "MutatingWebhookConfigurationList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration]) : MutatingWebhookConfigurationList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration*) : MutatingWebhookConfigurationList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration] => Seq[io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration]) : MutatingWebhookConfigurationList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : MutatingWebhookConfigurationList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : MutatingWebhookConfigurationList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = MutatingWebhookConfigurationList.encoder[T].apply(this)
}

object MutatingWebhookConfigurationList {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.admissionregistration.v1.MutatingWebhookConfigurationList, T] = new Encoder[io.k8s.api.admissionregistration.v1.MutatingWebhookConfigurationList, T] {
        def apply(o: io.k8s.api.admissionregistration.v1.MutatingWebhookConfigurationList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, MutatingWebhookConfigurationList] = new Decoder[T, MutatingWebhookConfigurationList] {
      def apply(t: T): Either[String, MutatingWebhookConfigurationList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield MutatingWebhookConfigurationList (
          items = items,
          metadata = metadata
        )
    }
}

