package io.k8s.api.storagemigration.v1alpha1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** StorageVersionMigrationList is a collection of storage version migrations. */
final case class StorageVersionMigrationList(
  items : Seq[io.k8s.api.storagemigration.v1alpha1.StorageVersionMigration],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("storagemigration.k8s.io", "StorageVersionMigrationList", "v1alpha1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.storagemigration.v1alpha1.StorageVersionMigration]) : StorageVersionMigrationList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.storagemigration.v1alpha1.StorageVersionMigration*) : StorageVersionMigrationList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.storagemigration.v1alpha1.StorageVersionMigration] => Seq[io.k8s.api.storagemigration.v1alpha1.StorageVersionMigration]) : StorageVersionMigrationList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : StorageVersionMigrationList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : StorageVersionMigrationList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = StorageVersionMigrationList.encoder.apply(this)
}

object StorageVersionMigrationList {

    implicit val encoder : Encoder[io.k8s.api.storagemigration.v1alpha1.StorageVersionMigrationList] = new Encoder[io.k8s.api.storagemigration.v1alpha1.StorageVersionMigrationList] {
        def apply[T : Builder](o: io.k8s.api.storagemigration.v1alpha1.StorageVersionMigrationList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[StorageVersionMigrationList] = new Decoder[StorageVersionMigrationList] {
      def apply[T : Reader](t: T): Either[String, StorageVersionMigrationList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.storagemigration.v1alpha1.StorageVersionMigration]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield StorageVersionMigrationList (
          items = items,
          metadata = metadata
        )
    }
}

