package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** ServiceSpec describes the attributes that a user creates on a service. */
final case class ServiceSpec(
  sessionAffinityConfig : Option[io.k8s.api.core.v1.SessionAffinityConfig] = None,
  loadBalancerSourceRanges : Option[Seq[String]] = None,
  sessionAffinity : Option[String] = None,
  clusterIPs : Option[Seq[String]] = None,
  externalTrafficPolicy : Option[String] = None,
  loadBalancerIP : Option[String] = None,
  clusterIP : Option[String] = None,
  ports : Option[Seq[io.k8s.api.core.v1.ServicePort]] = None,
  healthCheckNodePort : Option[Int] = None,
  allocateLoadBalancerNodePorts : Option[Boolean] = None,
  externalIPs : Option[Seq[String]] = None,
  ipFamilies : Option[Seq[String]] = None,
  trafficDistribution : Option[String] = None,
  internalTrafficPolicy : Option[String] = None,
  externalName : Option[String] = None,
  ipFamilyPolicy : Option[String] = None,
  `type` : Option[String] = None,
  selector : Option[Map[String, String]] = None,
  loadBalancerClass : Option[String] = None,
  publishNotReadyAddresses : Option[Boolean] = None
) {

  /** Returns a new data with sessionAffinityConfig set to new value */
  def withSessionAffinityConfig(value: io.k8s.api.core.v1.SessionAffinityConfig) : ServiceSpec = copy(sessionAffinityConfig = Some(value))
  /** if sessionAffinityConfig has a value, transforms to the result of function*/
  def mapSessionAffinityConfig(f: io.k8s.api.core.v1.SessionAffinityConfig => io.k8s.api.core.v1.SessionAffinityConfig) : ServiceSpec = copy(sessionAffinityConfig = sessionAffinityConfig.map(f))

  /** Returns a new data with loadBalancerSourceRanges set to new value */
  def withLoadBalancerSourceRanges(value: Seq[String]) : ServiceSpec = copy(loadBalancerSourceRanges = Some(value))
  /** Appends new values to loadBalancerSourceRanges */
  def addLoadBalancerSourceRanges(newValues: String*) : ServiceSpec = copy(loadBalancerSourceRanges = Some(loadBalancerSourceRanges.fold(newValues)(_ ++ newValues)))
  /** if loadBalancerSourceRanges has a value, transforms to the result of function*/
  def mapLoadBalancerSourceRanges(f: Seq[String] => Seq[String]) : ServiceSpec = copy(loadBalancerSourceRanges = loadBalancerSourceRanges.map(f))

  /** Returns a new data with sessionAffinity set to new value */
  def withSessionAffinity(value: String) : ServiceSpec = copy(sessionAffinity = Some(value))
  /** if sessionAffinity has a value, transforms to the result of function*/
  def mapSessionAffinity(f: String => String) : ServiceSpec = copy(sessionAffinity = sessionAffinity.map(f))

  /** Returns a new data with clusterIPs set to new value */
  def withClusterIPs(value: Seq[String]) : ServiceSpec = copy(clusterIPs = Some(value))
  /** Appends new values to clusterIPs */
  def addClusterIPs(newValues: String*) : ServiceSpec = copy(clusterIPs = Some(clusterIPs.fold(newValues)(_ ++ newValues)))
  /** if clusterIPs has a value, transforms to the result of function*/
  def mapClusterIPs(f: Seq[String] => Seq[String]) : ServiceSpec = copy(clusterIPs = clusterIPs.map(f))

  /** Returns a new data with externalTrafficPolicy set to new value */
  def withExternalTrafficPolicy(value: String) : ServiceSpec = copy(externalTrafficPolicy = Some(value))
  /** if externalTrafficPolicy has a value, transforms to the result of function*/
  def mapExternalTrafficPolicy(f: String => String) : ServiceSpec = copy(externalTrafficPolicy = externalTrafficPolicy.map(f))

  /** Returns a new data with loadBalancerIP set to new value */
  def withLoadBalancerIP(value: String) : ServiceSpec = copy(loadBalancerIP = Some(value))
  /** if loadBalancerIP has a value, transforms to the result of function*/
  def mapLoadBalancerIP(f: String => String) : ServiceSpec = copy(loadBalancerIP = loadBalancerIP.map(f))

  /** Returns a new data with clusterIP set to new value */
  def withClusterIP(value: String) : ServiceSpec = copy(clusterIP = Some(value))
  /** if clusterIP has a value, transforms to the result of function*/
  def mapClusterIP(f: String => String) : ServiceSpec = copy(clusterIP = clusterIP.map(f))

  /** Returns a new data with ports set to new value */
  def withPorts(value: Seq[io.k8s.api.core.v1.ServicePort]) : ServiceSpec = copy(ports = Some(value))
  /** Appends new values to ports */
  def addPorts(newValues: io.k8s.api.core.v1.ServicePort*) : ServiceSpec = copy(ports = Some(ports.fold(newValues)(_ ++ newValues)))
  /** if ports has a value, transforms to the result of function*/
  def mapPorts(f: Seq[io.k8s.api.core.v1.ServicePort] => Seq[io.k8s.api.core.v1.ServicePort]) : ServiceSpec = copy(ports = ports.map(f))

  /** Returns a new data with healthCheckNodePort set to new value */
  def withHealthCheckNodePort(value: Int) : ServiceSpec = copy(healthCheckNodePort = Some(value))
  /** if healthCheckNodePort has a value, transforms to the result of function*/
  def mapHealthCheckNodePort(f: Int => Int) : ServiceSpec = copy(healthCheckNodePort = healthCheckNodePort.map(f))

  /** Returns a new data with allocateLoadBalancerNodePorts set to new value */
  def withAllocateLoadBalancerNodePorts(value: Boolean) : ServiceSpec = copy(allocateLoadBalancerNodePorts = Some(value))
  /** if allocateLoadBalancerNodePorts has a value, transforms to the result of function*/
  def mapAllocateLoadBalancerNodePorts(f: Boolean => Boolean) : ServiceSpec = copy(allocateLoadBalancerNodePorts = allocateLoadBalancerNodePorts.map(f))

  /** Returns a new data with externalIPs set to new value */
  def withExternalIPs(value: Seq[String]) : ServiceSpec = copy(externalIPs = Some(value))
  /** Appends new values to externalIPs */
  def addExternalIPs(newValues: String*) : ServiceSpec = copy(externalIPs = Some(externalIPs.fold(newValues)(_ ++ newValues)))
  /** if externalIPs has a value, transforms to the result of function*/
  def mapExternalIPs(f: Seq[String] => Seq[String]) : ServiceSpec = copy(externalIPs = externalIPs.map(f))

  /** Returns a new data with ipFamilies set to new value */
  def withIpFamilies(value: Seq[String]) : ServiceSpec = copy(ipFamilies = Some(value))
  /** Appends new values to ipFamilies */
  def addIpFamilies(newValues: String*) : ServiceSpec = copy(ipFamilies = Some(ipFamilies.fold(newValues)(_ ++ newValues)))
  /** if ipFamilies has a value, transforms to the result of function*/
  def mapIpFamilies(f: Seq[String] => Seq[String]) : ServiceSpec = copy(ipFamilies = ipFamilies.map(f))

  /** Returns a new data with trafficDistribution set to new value */
  def withTrafficDistribution(value: String) : ServiceSpec = copy(trafficDistribution = Some(value))
  /** if trafficDistribution has a value, transforms to the result of function*/
  def mapTrafficDistribution(f: String => String) : ServiceSpec = copy(trafficDistribution = trafficDistribution.map(f))

  /** Returns a new data with internalTrafficPolicy set to new value */
  def withInternalTrafficPolicy(value: String) : ServiceSpec = copy(internalTrafficPolicy = Some(value))
  /** if internalTrafficPolicy has a value, transforms to the result of function*/
  def mapInternalTrafficPolicy(f: String => String) : ServiceSpec = copy(internalTrafficPolicy = internalTrafficPolicy.map(f))

  /** Returns a new data with externalName set to new value */
  def withExternalName(value: String) : ServiceSpec = copy(externalName = Some(value))
  /** if externalName has a value, transforms to the result of function*/
  def mapExternalName(f: String => String) : ServiceSpec = copy(externalName = externalName.map(f))

  /** Returns a new data with ipFamilyPolicy set to new value */
  def withIpFamilyPolicy(value: String) : ServiceSpec = copy(ipFamilyPolicy = Some(value))
  /** if ipFamilyPolicy has a value, transforms to the result of function*/
  def mapIpFamilyPolicy(f: String => String) : ServiceSpec = copy(ipFamilyPolicy = ipFamilyPolicy.map(f))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : ServiceSpec = copy(`type` = Some(value))
  /** if `type` has a value, transforms to the result of function*/
  def mapType(f: String => String) : ServiceSpec = copy(`type` = `type`.map(f))

  /** Returns a new data with selector set to new value */
  def withSelector(value: Map[String, String]) : ServiceSpec = copy(selector = Some(value))
  /** Adds new values to selector */
  def addSelector(newValues: (String, String)*) : ServiceSpec = copy(selector = Some(selector.fold(newValues.toMap)(_ ++ newValues)))
  /** if selector has a value, transforms to the result of function*/
  def mapSelector(f: Map[String, String] => Map[String, String]) : ServiceSpec = copy(selector = selector.map(f))

  /** Returns a new data with loadBalancerClass set to new value */
  def withLoadBalancerClass(value: String) : ServiceSpec = copy(loadBalancerClass = Some(value))
  /** if loadBalancerClass has a value, transforms to the result of function*/
  def mapLoadBalancerClass(f: String => String) : ServiceSpec = copy(loadBalancerClass = loadBalancerClass.map(f))

  /** Returns a new data with publishNotReadyAddresses set to new value */
  def withPublishNotReadyAddresses(value: Boolean) : ServiceSpec = copy(publishNotReadyAddresses = Some(value))
  /** if publishNotReadyAddresses has a value, transforms to the result of function*/
  def mapPublishNotReadyAddresses(f: Boolean => Boolean) : ServiceSpec = copy(publishNotReadyAddresses = publishNotReadyAddresses.map(f))
}

object ServiceSpec {

    implicit val encoder : Encoder[io.k8s.api.core.v1.ServiceSpec] = new Encoder[io.k8s.api.core.v1.ServiceSpec] {
        def apply[T : Builder](o: io.k8s.api.core.v1.ServiceSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("sessionAffinityConfig", o.sessionAffinityConfig)
            .write("loadBalancerSourceRanges", o.loadBalancerSourceRanges)
            .write("sessionAffinity", o.sessionAffinity)
            .write("clusterIPs", o.clusterIPs)
            .write("externalTrafficPolicy", o.externalTrafficPolicy)
            .write("loadBalancerIP", o.loadBalancerIP)
            .write("clusterIP", o.clusterIP)
            .write("ports", o.ports)
            .write("healthCheckNodePort", o.healthCheckNodePort)
            .write("allocateLoadBalancerNodePorts", o.allocateLoadBalancerNodePorts)
            .write("externalIPs", o.externalIPs)
            .write("ipFamilies", o.ipFamilies)
            .write("trafficDistribution", o.trafficDistribution)
            .write("internalTrafficPolicy", o.internalTrafficPolicy)
            .write("externalName", o.externalName)
            .write("ipFamilyPolicy", o.ipFamilyPolicy)
            .write("type", o.`type`)
            .write("selector", o.selector)
            .write("loadBalancerClass", o.loadBalancerClass)
            .write("publishNotReadyAddresses", o.publishNotReadyAddresses)
            .build
        }
    }

    implicit val decoder: Decoder[ServiceSpec] = new Decoder[ServiceSpec] {
      def apply[T : Reader](t: T): Either[String, ServiceSpec] = for {
          obj <- ObjectReader(t)
          sessionAffinityConfig <- obj.readOpt[io.k8s.api.core.v1.SessionAffinityConfig]("sessionAffinityConfig")
          loadBalancerSourceRanges <- obj.readOpt[Seq[String]]("loadBalancerSourceRanges")
          sessionAffinity <- obj.readOpt[String]("sessionAffinity")
          clusterIPs <- obj.readOpt[Seq[String]]("clusterIPs")
          externalTrafficPolicy <- obj.readOpt[String]("externalTrafficPolicy")
          loadBalancerIP <- obj.readOpt[String]("loadBalancerIP")
          clusterIP <- obj.readOpt[String]("clusterIP")
          ports <- obj.readOpt[Seq[io.k8s.api.core.v1.ServicePort]]("ports")
          healthCheckNodePort <- obj.readOpt[Int]("healthCheckNodePort")
          allocateLoadBalancerNodePorts <- obj.readOpt[Boolean]("allocateLoadBalancerNodePorts")
          externalIPs <- obj.readOpt[Seq[String]]("externalIPs")
          ipFamilies <- obj.readOpt[Seq[String]]("ipFamilies")
          trafficDistribution <- obj.readOpt[String]("trafficDistribution")
          internalTrafficPolicy <- obj.readOpt[String]("internalTrafficPolicy")
          externalName <- obj.readOpt[String]("externalName")
          ipFamilyPolicy <- obj.readOpt[String]("ipFamilyPolicy")
          `type` <- obj.readOpt[String]("type")
          selector <- obj.readOpt[Map[String, String]]("selector")
          loadBalancerClass <- obj.readOpt[String]("loadBalancerClass")
          publishNotReadyAddresses <- obj.readOpt[Boolean]("publishNotReadyAddresses")
      } yield ServiceSpec (
          sessionAffinityConfig = sessionAffinityConfig,
          loadBalancerSourceRanges = loadBalancerSourceRanges,
          sessionAffinity = sessionAffinity,
          clusterIPs = clusterIPs,
          externalTrafficPolicy = externalTrafficPolicy,
          loadBalancerIP = loadBalancerIP,
          clusterIP = clusterIP,
          ports = ports,
          healthCheckNodePort = healthCheckNodePort,
          allocateLoadBalancerNodePorts = allocateLoadBalancerNodePorts,
          externalIPs = externalIPs,
          ipFamilies = ipFamilies,
          trafficDistribution = trafficDistribution,
          internalTrafficPolicy = internalTrafficPolicy,
          externalName = externalName,
          ipFamilyPolicy = ipFamilyPolicy,
          `type` = `type`,
          selector = selector,
          loadBalancerClass = loadBalancerClass,
          publishNotReadyAddresses = publishNotReadyAddresses
        )
    }
}

