package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** NodeRuntimeHandlerFeatures is a set of runtime features. */
final case class NodeRuntimeHandlerFeatures(
  recursiveReadOnlyMounts : Option[Boolean] = None
) {

  /** Returns a new data with recursiveReadOnlyMounts set to new value */
  def withRecursiveReadOnlyMounts(value: Boolean) : NodeRuntimeHandlerFeatures = copy(recursiveReadOnlyMounts = Some(value))
  /** if recursiveReadOnlyMounts has a value, transforms to the result of function*/
  def mapRecursiveReadOnlyMounts(f: Boolean => Boolean) : NodeRuntimeHandlerFeatures = copy(recursiveReadOnlyMounts = recursiveReadOnlyMounts.map(f))
}

object NodeRuntimeHandlerFeatures {

    implicit val encoder : Encoder[io.k8s.api.core.v1.NodeRuntimeHandlerFeatures] = new Encoder[io.k8s.api.core.v1.NodeRuntimeHandlerFeatures] {
        def apply[T : Builder](o: io.k8s.api.core.v1.NodeRuntimeHandlerFeatures) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("recursiveReadOnlyMounts", o.recursiveReadOnlyMounts)
            .build
        }
    }

    implicit val decoder: Decoder[NodeRuntimeHandlerFeatures] = new Decoder[NodeRuntimeHandlerFeatures] {
      def apply[T : Reader](t: T): Either[String, NodeRuntimeHandlerFeatures] = for {
          obj <- ObjectReader(t)
          recursiveReadOnlyMounts <- obj.readOpt[Boolean]("recursiveReadOnlyMounts")
      } yield NodeRuntimeHandlerFeatures (
          recursiveReadOnlyMounts = recursiveReadOnlyMounts
        )
    }
}

