package io.k8s.api.authentication.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** SelfSubjectReview contains the user information that the kube-apiserver has about the user making this request. When using impersonation, users will receive the user info of the user being impersonated.  If impersonation or request header authentication is used, any extra keys will have their case ignored and returned as lowercase. */
final case class SelfSubjectReview(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  status : Option[io.k8s.api.authentication.v1.SelfSubjectReviewStatus] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("authentication.k8s.io", "SelfSubjectReview", "v1")


  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : SelfSubjectReview = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : SelfSubjectReview = copy(metadata = metadata.map(f))

  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.authentication.v1.SelfSubjectReviewStatus) : SelfSubjectReview = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.authentication.v1.SelfSubjectReviewStatus => io.k8s.api.authentication.v1.SelfSubjectReviewStatus) : SelfSubjectReview = copy(status = status.map(f))

  override def foldTo[T : Builder] : T = SelfSubjectReview.encoder.apply(this)
}

object SelfSubjectReview {

    implicit val encoder : Encoder[io.k8s.api.authentication.v1.SelfSubjectReview] = new Encoder[io.k8s.api.authentication.v1.SelfSubjectReview] {
        def apply[T : Builder](o: io.k8s.api.authentication.v1.SelfSubjectReview) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("metadata", o.metadata)
            .write("status", o.status)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[SelfSubjectReview] = new Decoder[SelfSubjectReview] {
      def apply[T : Reader](t: T): Either[String, SelfSubjectReview] = for {
          obj <- ObjectReader(t)
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
          status <- obj.readOpt[io.k8s.api.authentication.v1.SelfSubjectReviewStatus]("status")
      } yield SelfSubjectReview (
          metadata = metadata,
          status = status
        )
    }
}

