package io.k8s.api.apps.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** Deployment enables declarative updates for Pods and ReplicaSets. */
final case class Deployment(
  status : Option[io.k8s.api.apps.v1.DeploymentStatus] = None,
  spec : Option[io.k8s.api.apps.v1.DeploymentSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apps", "Deployment", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.apps.v1.DeploymentStatus) : Deployment = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.apps.v1.DeploymentStatus => io.k8s.api.apps.v1.DeploymentStatus) : Deployment = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.apps.v1.DeploymentSpec) : Deployment = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.apps.v1.DeploymentSpec => io.k8s.api.apps.v1.DeploymentSpec) : Deployment = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Deployment = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Deployment = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = Deployment.encoder.apply(this)
}

object Deployment {

    implicit val encoder : Encoder[io.k8s.api.apps.v1.Deployment] = new Encoder[io.k8s.api.apps.v1.Deployment] {
        def apply[T : Builder](o: io.k8s.api.apps.v1.Deployment) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[Deployment] = new Decoder[Deployment] {
      def apply[T : Reader](t: T): Either[String, Deployment] = for {
          obj <- ObjectReader(t)
          status <- obj.readOpt[io.k8s.api.apps.v1.DeploymentStatus]("status")
          spec <- obj.readOpt[io.k8s.api.apps.v1.DeploymentSpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield Deployment (
          status = status,
          spec = spec,
          metadata = metadata
        )
    }
}

