package io.k8s.api.admissionregistration.v1alpha1

import dev.hnaderi.k8s.utils._

/** AuditAnnotation describes how to produce an audit annotation for an API request. */
final case class AuditAnnotation(
  key : String,
  valueExpression : String
) {

  /** Returns a new data with key set to new value */
  def withKey(value: String) : AuditAnnotation = copy(key = value)
  /** transforms key to result of function */
  def mapKey(f: String => String) : AuditAnnotation = copy(key = f(key))

  /** Returns a new data with valueExpression set to new value */
  def withValueExpression(value: String) : AuditAnnotation = copy(valueExpression = value)
  /** transforms valueExpression to result of function */
  def mapValueExpression(f: String => String) : AuditAnnotation = copy(valueExpression = f(valueExpression))
}

object AuditAnnotation {

    implicit val encoder : Encoder[io.k8s.api.admissionregistration.v1alpha1.AuditAnnotation] = new Encoder[io.k8s.api.admissionregistration.v1alpha1.AuditAnnotation] {
        def apply[T : Builder](o: io.k8s.api.admissionregistration.v1alpha1.AuditAnnotation) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("key", o.key)
            .write("valueExpression", o.valueExpression)
            .build
        }
    }

    implicit val decoder: Decoder[AuditAnnotation] = new Decoder[AuditAnnotation] {
      def apply[T : Reader](t: T): Either[String, AuditAnnotation] = for {
          obj <- ObjectReader(t)
          key <- obj.read[String]("key")
          valueExpression <- obj.read[String]("valueExpression")
      } yield AuditAnnotation (
          key = key,
          valueExpression = valueExpression
        )
    }
}

