package io.k8s.apimachinery.pkg.apis.meta.v1


/** Preconditions must be fulfilled before an operation (update, delete, etc.) is carried out. */
final case class Preconditions(
  resourceVersion : Option[String] = None,
  uid : Option[String] = None
) {

  /** Returns a new data with resourceVersion set to new value */
  def withResourceVersion(value: String) : Preconditions = copy(resourceVersion = Some(value))
  /** if resourceVersion has a value, transforms to the result of function*/
  def mapResourceVersion(f: String => String) : Preconditions = copy(resourceVersion = resourceVersion.map(f))

  /** Returns a new data with uid set to new value */
  def withUid(value: String) : Preconditions = copy(uid = Some(value))
  /** if uid has a value, transforms to the result of function*/
  def mapUid(f: String => String) : Preconditions = copy(uid = uid.map(f))
}

