package io.k8s.api.rbac.v1


/** AggregationRule describes how to locate ClusterRoles to aggregate into the ClusterRole */
final case class AggregationRule(
  clusterRoleSelectors : Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]] = None
) {

  /** Returns a new data with clusterRoleSelectors set to new value */
  def withClusterRoleSelectors(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]) : AggregationRule = copy(clusterRoleSelectors = Some(value))
  /** Appends new values to clusterRoleSelectors */
  def addClusterRoleSelectors(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector*) : AggregationRule = copy(clusterRoleSelectors = Some(clusterRoleSelectors.fold(newValues)(_ ++ newValues)))
  /** if clusterRoleSelectors has a value, transforms to the result of function*/
  def mapClusterRoleSelectors(f: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] => Seq[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]) : AggregationRule = copy(clusterRoleSelectors = clusterRoleSelectors.map(f))
}

