package io.k8s.api.core.v1


/** PersistentVolumeClaimSpec describes the common attributes of storage devices and allows a Source for provider-specific attributes */
final case class PersistentVolumeClaimSpec(
  accessModes : Option[Seq[String]] = None,
  volumeMode : Option[String] = None,
  dataSourceRef : Option[io.k8s.api.core.v1.TypedLocalObjectReference] = None,
  storageClassName : Option[String] = None,
  dataSource : Option[io.k8s.api.core.v1.TypedLocalObjectReference] = None,
  volumeName : Option[String] = None,
  resources : Option[io.k8s.api.core.v1.ResourceRequirements] = None,
  selector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None
) {

  /** Returns a new data with accessModes set to new value */
  def withAccessModes(value: Seq[String]) : PersistentVolumeClaimSpec = copy(accessModes = Some(value))
  /** Appends new values to accessModes */
  def addAccessModes(newValues: String*) : PersistentVolumeClaimSpec = copy(accessModes = Some(accessModes.fold(newValues)(_ ++ newValues)))
  /** if accessModes has a value, transforms to the result of function*/
  def mapAccessModes(f: Seq[String] => Seq[String]) : PersistentVolumeClaimSpec = copy(accessModes = accessModes.map(f))

  /** Returns a new data with volumeMode set to new value */
  def withVolumeMode(value: String) : PersistentVolumeClaimSpec = copy(volumeMode = Some(value))
  /** if volumeMode has a value, transforms to the result of function*/
  def mapVolumeMode(f: String => String) : PersistentVolumeClaimSpec = copy(volumeMode = volumeMode.map(f))

  /** Returns a new data with dataSourceRef set to new value */
  def withDataSourceRef(value: io.k8s.api.core.v1.TypedLocalObjectReference) : PersistentVolumeClaimSpec = copy(dataSourceRef = Some(value))
  /** if dataSourceRef has a value, transforms to the result of function*/
  def mapDataSourceRef(f: io.k8s.api.core.v1.TypedLocalObjectReference => io.k8s.api.core.v1.TypedLocalObjectReference) : PersistentVolumeClaimSpec = copy(dataSourceRef = dataSourceRef.map(f))

  /** Returns a new data with storageClassName set to new value */
  def withStorageClassName(value: String) : PersistentVolumeClaimSpec = copy(storageClassName = Some(value))
  /** if storageClassName has a value, transforms to the result of function*/
  def mapStorageClassName(f: String => String) : PersistentVolumeClaimSpec = copy(storageClassName = storageClassName.map(f))

  /** Returns a new data with dataSource set to new value */
  def withDataSource(value: io.k8s.api.core.v1.TypedLocalObjectReference) : PersistentVolumeClaimSpec = copy(dataSource = Some(value))
  /** if dataSource has a value, transforms to the result of function*/
  def mapDataSource(f: io.k8s.api.core.v1.TypedLocalObjectReference => io.k8s.api.core.v1.TypedLocalObjectReference) : PersistentVolumeClaimSpec = copy(dataSource = dataSource.map(f))

  /** Returns a new data with volumeName set to new value */
  def withVolumeName(value: String) : PersistentVolumeClaimSpec = copy(volumeName = Some(value))
  /** if volumeName has a value, transforms to the result of function*/
  def mapVolumeName(f: String => String) : PersistentVolumeClaimSpec = copy(volumeName = volumeName.map(f))

  /** Returns a new data with resources set to new value */
  def withResources(value: io.k8s.api.core.v1.ResourceRequirements) : PersistentVolumeClaimSpec = copy(resources = Some(value))
  /** if resources has a value, transforms to the result of function*/
  def mapResources(f: io.k8s.api.core.v1.ResourceRequirements => io.k8s.api.core.v1.ResourceRequirements) : PersistentVolumeClaimSpec = copy(resources = resources.map(f))

  /** Returns a new data with selector set to new value */
  def withSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : PersistentVolumeClaimSpec = copy(selector = Some(value))
  /** if selector has a value, transforms to the result of function*/
  def mapSelector(f: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector => io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : PersistentVolumeClaimSpec = copy(selector = selector.map(f))
}

