package io.k8s.api.core.v1


/** ContainerStateWaiting is a waiting state of a container. */
final case class ContainerStateWaiting(
  message : Option[String] = None,
  reason : Option[String] = None
) {

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : ContainerStateWaiting = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : ContainerStateWaiting = copy(message = message.map(f))

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : ContainerStateWaiting = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : ContainerStateWaiting = copy(reason = reason.map(f))
}

