package io.k8s.api.coordination.v1

import dev.hnaderi.k8s._

/** LeaseList is a list of Lease objects. */
final case class LeaseList(
  items : Seq[io.k8s.api.coordination.v1.Lease],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("coordination.k8s.io", "LeaseList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.coordination.v1.Lease]) : LeaseList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.coordination.v1.Lease*) : LeaseList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.coordination.v1.Lease] => Seq[io.k8s.api.coordination.v1.Lease]) : LeaseList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : LeaseList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : LeaseList = copy(metadata = metadata.map(f))
}

