package io.k8s.api.autoscaling.v2beta2

import dev.hnaderi.k8s._

/** HorizontalPodAutoscalerList is a list of horizontal pod autoscaler objects. */
final case class HorizontalPodAutoscalerList(
  items : Seq[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("autoscaling", "HorizontalPodAutoscalerList", "v2beta2")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler]) : HorizontalPodAutoscalerList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler*) : HorizontalPodAutoscalerList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler] => Seq[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler]) : HorizontalPodAutoscalerList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : HorizontalPodAutoscalerList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : HorizontalPodAutoscalerList = copy(metadata = metadata.map(f))
}

