package io.k8s.api.autoscaling.v1

import dev.hnaderi.k8s._

/** configuration of a horizontal pod autoscaler. */
final case class HorizontalPodAutoscaler(
  status : Option[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerStatus] = None,
  spec : Option[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("autoscaling", "HorizontalPodAutoscaler", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerStatus) : HorizontalPodAutoscaler = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerStatus => io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerStatus) : HorizontalPodAutoscaler = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec) : HorizontalPodAutoscaler = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec => io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec) : HorizontalPodAutoscaler = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : HorizontalPodAutoscaler = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : HorizontalPodAutoscaler = copy(metadata = metadata.map(f))
}

