package io.k8s.api.admissionregistration.v1alpha1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ValidatingAdmissionPolicy describes the definition of an admission validation policy that accepts or rejects an object without changing it. */
final case class ValidatingAdmissionPolicy(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec : Option[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicySpec] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("admissionregistration.k8s.io", "ValidatingAdmissionPolicy", "v1alpha1")


  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ValidatingAdmissionPolicy = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ValidatingAdmissionPolicy = copy(metadata = metadata.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicySpec) : ValidatingAdmissionPolicy = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicySpec => io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicySpec) : ValidatingAdmissionPolicy = copy(spec = spec.map(f))

  override def foldTo[T : Builder] : T = ValidatingAdmissionPolicy.encoder.apply(this)
}

object ValidatingAdmissionPolicy {

    implicit val encoder : Encoder[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicy] = new Encoder[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicy] {
        def apply[T : Builder](o: io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicy) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("metadata", o.metadata)
            .write("spec", o.spec)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[ValidatingAdmissionPolicy] = new Decoder[ValidatingAdmissionPolicy] {
      def apply[T : Reader](t: T): Either[String, ValidatingAdmissionPolicy] = for {
          obj <- ObjectReader(t)
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
          spec <- obj.readOpt[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicySpec]("spec")
      } yield ValidatingAdmissionPolicy (
          metadata = metadata,
          spec = spec
        )
    }
}

