package io.k8s.api.resource.v1alpha1

import dev.hnaderi.k8s.utils._

/** ResourceClaimParametersReference contains enough information to let you locate the parameters for a ResourceClaim. The object must be in the same namespace as the ResourceClaim. */
final case class ResourceClaimParametersReference(
  name : String,
  apiGroup : Option[String] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : ResourceClaimParametersReference = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : ResourceClaimParametersReference = copy(name = f(name))

  /** Returns a new data with apiGroup set to new value */
  def withApiGroup(value: String) : ResourceClaimParametersReference = copy(apiGroup = Some(value))
  /** if apiGroup has a value, transforms to the result of function*/
  def mapApiGroup(f: String => String) : ResourceClaimParametersReference = copy(apiGroup = apiGroup.map(f))
}

object ResourceClaimParametersReference {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha1.ResourceClaimParametersReference] = new Encoder[io.k8s.api.resource.v1alpha1.ResourceClaimParametersReference] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha1.ResourceClaimParametersReference) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("apiGroup", o.apiGroup)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceClaimParametersReference] = new Decoder[ResourceClaimParametersReference] {
      def apply[T : Reader](t: T): Either[String, ResourceClaimParametersReference] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
          apiGroup <- obj.readOpt[String]("apiGroup")
      } yield ResourceClaimParametersReference (
          name = name,
          apiGroup = apiGroup
        )
    }
}

