package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** PodSpec is a description of a pod. */
final case class PodSpec(
  containers : Seq[io.k8s.api.core.v1.Container],
  schedulingGates : Option[Seq[io.k8s.api.core.v1.PodSchedulingGate]] = None,
  priority : Option[Int] = None,
  hostIPC : Option[Boolean] = None,
  serviceAccount : Option[String] = None,
  schedulerName : Option[String] = None,
  hostname : Option[String] = None,
  imagePullSecrets : Option[Seq[io.k8s.api.core.v1.LocalObjectReference]] = None,
  affinity : Option[io.k8s.api.core.v1.Affinity] = None,
  os : Option[io.k8s.api.core.v1.PodOS] = None,
  nodeName : Option[String] = None,
  ephemeralContainers : Option[Seq[io.k8s.api.core.v1.EphemeralContainer]] = None,
  initContainers : Option[Seq[io.k8s.api.core.v1.Container]] = None,
  shareProcessNamespace : Option[Boolean] = None,
  setHostnameAsFQDN : Option[Boolean] = None,
  enableServiceLinks : Option[Boolean] = None,
  preemptionPolicy : Option[String] = None,
  dnsPolicy : Option[String] = None,
  volumes : Option[Seq[io.k8s.api.core.v1.Volume]] = None,
  hostAliases : Option[Seq[io.k8s.api.core.v1.HostAlias]] = None,
  subdomain : Option[String] = None,
  topologySpreadConstraints : Option[Seq[io.k8s.api.core.v1.TopologySpreadConstraint]] = None,
  overhead : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  tolerations : Option[Seq[io.k8s.api.core.v1.Toleration]] = None,
  automountServiceAccountToken : Option[Boolean] = None,
  nodeSelector : Option[Map[String, String]] = None,
  hostPID : Option[Boolean] = None,
  terminationGracePeriodSeconds : Option[Int] = None,
  dnsConfig : Option[io.k8s.api.core.v1.PodDNSConfig] = None,
  priorityClassName : Option[String] = None,
  serviceAccountName : Option[String] = None,
  restartPolicy : Option[String] = None,
  resourceClaims : Option[Seq[io.k8s.api.core.v1.PodResourceClaim]] = None,
  hostUsers : Option[Boolean] = None,
  runtimeClassName : Option[String] = None,
  readinessGates : Option[Seq[io.k8s.api.core.v1.PodReadinessGate]] = None,
  activeDeadlineSeconds : Option[Int] = None,
  hostNetwork : Option[Boolean] = None,
  securityContext : Option[io.k8s.api.core.v1.PodSecurityContext] = None
) {

  /** Returns a new data with containers set to new value */
  def withContainers(value: Seq[io.k8s.api.core.v1.Container]) : PodSpec = copy(containers = value)
  /** Appends new values to containers */
  def addContainers(newValues: io.k8s.api.core.v1.Container*) : PodSpec = copy(containers = containers ++ newValues)
  /** transforms containers to result of function */
  def mapContainers(f: Seq[io.k8s.api.core.v1.Container] => Seq[io.k8s.api.core.v1.Container]) : PodSpec = copy(containers = f(containers))

  /** Returns a new data with schedulingGates set to new value */
  def withSchedulingGates(value: Seq[io.k8s.api.core.v1.PodSchedulingGate]) : PodSpec = copy(schedulingGates = Some(value))
  /** Appends new values to schedulingGates */
  def addSchedulingGates(newValues: io.k8s.api.core.v1.PodSchedulingGate*) : PodSpec = copy(schedulingGates = Some(schedulingGates.fold(newValues)(_ ++ newValues)))
  /** if schedulingGates has a value, transforms to the result of function*/
  def mapSchedulingGates(f: Seq[io.k8s.api.core.v1.PodSchedulingGate] => Seq[io.k8s.api.core.v1.PodSchedulingGate]) : PodSpec = copy(schedulingGates = schedulingGates.map(f))

  /** Returns a new data with priority set to new value */
  def withPriority(value: Int) : PodSpec = copy(priority = Some(value))
  /** if priority has a value, transforms to the result of function*/
  def mapPriority(f: Int => Int) : PodSpec = copy(priority = priority.map(f))

  /** Returns a new data with hostIPC set to new value */
  def withHostIPC(value: Boolean) : PodSpec = copy(hostIPC = Some(value))
  /** if hostIPC has a value, transforms to the result of function*/
  def mapHostIPC(f: Boolean => Boolean) : PodSpec = copy(hostIPC = hostIPC.map(f))

  /** Returns a new data with serviceAccount set to new value */
  def withServiceAccount(value: String) : PodSpec = copy(serviceAccount = Some(value))
  /** if serviceAccount has a value, transforms to the result of function*/
  def mapServiceAccount(f: String => String) : PodSpec = copy(serviceAccount = serviceAccount.map(f))

  /** Returns a new data with schedulerName set to new value */
  def withSchedulerName(value: String) : PodSpec = copy(schedulerName = Some(value))
  /** if schedulerName has a value, transforms to the result of function*/
  def mapSchedulerName(f: String => String) : PodSpec = copy(schedulerName = schedulerName.map(f))

  /** Returns a new data with hostname set to new value */
  def withHostname(value: String) : PodSpec = copy(hostname = Some(value))
  /** if hostname has a value, transforms to the result of function*/
  def mapHostname(f: String => String) : PodSpec = copy(hostname = hostname.map(f))

  /** Returns a new data with imagePullSecrets set to new value */
  def withImagePullSecrets(value: Seq[io.k8s.api.core.v1.LocalObjectReference]) : PodSpec = copy(imagePullSecrets = Some(value))
  /** Appends new values to imagePullSecrets */
  def addImagePullSecrets(newValues: io.k8s.api.core.v1.LocalObjectReference*) : PodSpec = copy(imagePullSecrets = Some(imagePullSecrets.fold(newValues)(_ ++ newValues)))
  /** if imagePullSecrets has a value, transforms to the result of function*/
  def mapImagePullSecrets(f: Seq[io.k8s.api.core.v1.LocalObjectReference] => Seq[io.k8s.api.core.v1.LocalObjectReference]) : PodSpec = copy(imagePullSecrets = imagePullSecrets.map(f))

  /** Returns a new data with affinity set to new value */
  def withAffinity(value: io.k8s.api.core.v1.Affinity) : PodSpec = copy(affinity = Some(value))
  /** if affinity has a value, transforms to the result of function*/
  def mapAffinity(f: io.k8s.api.core.v1.Affinity => io.k8s.api.core.v1.Affinity) : PodSpec = copy(affinity = affinity.map(f))

  /** Returns a new data with os set to new value */
  def withOs(value: io.k8s.api.core.v1.PodOS) : PodSpec = copy(os = Some(value))
  /** if os has a value, transforms to the result of function*/
  def mapOs(f: io.k8s.api.core.v1.PodOS => io.k8s.api.core.v1.PodOS) : PodSpec = copy(os = os.map(f))

  /** Returns a new data with nodeName set to new value */
  def withNodeName(value: String) : PodSpec = copy(nodeName = Some(value))
  /** if nodeName has a value, transforms to the result of function*/
  def mapNodeName(f: String => String) : PodSpec = copy(nodeName = nodeName.map(f))

  /** Returns a new data with ephemeralContainers set to new value */
  def withEphemeralContainers(value: Seq[io.k8s.api.core.v1.EphemeralContainer]) : PodSpec = copy(ephemeralContainers = Some(value))
  /** Appends new values to ephemeralContainers */
  def addEphemeralContainers(newValues: io.k8s.api.core.v1.EphemeralContainer*) : PodSpec = copy(ephemeralContainers = Some(ephemeralContainers.fold(newValues)(_ ++ newValues)))
  /** if ephemeralContainers has a value, transforms to the result of function*/
  def mapEphemeralContainers(f: Seq[io.k8s.api.core.v1.EphemeralContainer] => Seq[io.k8s.api.core.v1.EphemeralContainer]) : PodSpec = copy(ephemeralContainers = ephemeralContainers.map(f))

  /** Returns a new data with initContainers set to new value */
  def withInitContainers(value: Seq[io.k8s.api.core.v1.Container]) : PodSpec = copy(initContainers = Some(value))
  /** Appends new values to initContainers */
  def addInitContainers(newValues: io.k8s.api.core.v1.Container*) : PodSpec = copy(initContainers = Some(initContainers.fold(newValues)(_ ++ newValues)))
  /** if initContainers has a value, transforms to the result of function*/
  def mapInitContainers(f: Seq[io.k8s.api.core.v1.Container] => Seq[io.k8s.api.core.v1.Container]) : PodSpec = copy(initContainers = initContainers.map(f))

  /** Returns a new data with shareProcessNamespace set to new value */
  def withShareProcessNamespace(value: Boolean) : PodSpec = copy(shareProcessNamespace = Some(value))
  /** if shareProcessNamespace has a value, transforms to the result of function*/
  def mapShareProcessNamespace(f: Boolean => Boolean) : PodSpec = copy(shareProcessNamespace = shareProcessNamespace.map(f))

  /** Returns a new data with setHostnameAsFQDN set to new value */
  def withSetHostnameAsFQDN(value: Boolean) : PodSpec = copy(setHostnameAsFQDN = Some(value))
  /** if setHostnameAsFQDN has a value, transforms to the result of function*/
  def mapSetHostnameAsFQDN(f: Boolean => Boolean) : PodSpec = copy(setHostnameAsFQDN = setHostnameAsFQDN.map(f))

  /** Returns a new data with enableServiceLinks set to new value */
  def withEnableServiceLinks(value: Boolean) : PodSpec = copy(enableServiceLinks = Some(value))
  /** if enableServiceLinks has a value, transforms to the result of function*/
  def mapEnableServiceLinks(f: Boolean => Boolean) : PodSpec = copy(enableServiceLinks = enableServiceLinks.map(f))

  /** Returns a new data with preemptionPolicy set to new value */
  def withPreemptionPolicy(value: String) : PodSpec = copy(preemptionPolicy = Some(value))
  /** if preemptionPolicy has a value, transforms to the result of function*/
  def mapPreemptionPolicy(f: String => String) : PodSpec = copy(preemptionPolicy = preemptionPolicy.map(f))

  /** Returns a new data with dnsPolicy set to new value */
  def withDnsPolicy(value: String) : PodSpec = copy(dnsPolicy = Some(value))
  /** if dnsPolicy has a value, transforms to the result of function*/
  def mapDnsPolicy(f: String => String) : PodSpec = copy(dnsPolicy = dnsPolicy.map(f))

  /** Returns a new data with volumes set to new value */
  def withVolumes(value: Seq[io.k8s.api.core.v1.Volume]) : PodSpec = copy(volumes = Some(value))
  /** Appends new values to volumes */
  def addVolumes(newValues: io.k8s.api.core.v1.Volume*) : PodSpec = copy(volumes = Some(volumes.fold(newValues)(_ ++ newValues)))
  /** if volumes has a value, transforms to the result of function*/
  def mapVolumes(f: Seq[io.k8s.api.core.v1.Volume] => Seq[io.k8s.api.core.v1.Volume]) : PodSpec = copy(volumes = volumes.map(f))

  /** Returns a new data with hostAliases set to new value */
  def withHostAliases(value: Seq[io.k8s.api.core.v1.HostAlias]) : PodSpec = copy(hostAliases = Some(value))
  /** Appends new values to hostAliases */
  def addHostAliases(newValues: io.k8s.api.core.v1.HostAlias*) : PodSpec = copy(hostAliases = Some(hostAliases.fold(newValues)(_ ++ newValues)))
  /** if hostAliases has a value, transforms to the result of function*/
  def mapHostAliases(f: Seq[io.k8s.api.core.v1.HostAlias] => Seq[io.k8s.api.core.v1.HostAlias]) : PodSpec = copy(hostAliases = hostAliases.map(f))

  /** Returns a new data with subdomain set to new value */
  def withSubdomain(value: String) : PodSpec = copy(subdomain = Some(value))
  /** if subdomain has a value, transforms to the result of function*/
  def mapSubdomain(f: String => String) : PodSpec = copy(subdomain = subdomain.map(f))

  /** Returns a new data with topologySpreadConstraints set to new value */
  def withTopologySpreadConstraints(value: Seq[io.k8s.api.core.v1.TopologySpreadConstraint]) : PodSpec = copy(topologySpreadConstraints = Some(value))
  /** Appends new values to topologySpreadConstraints */
  def addTopologySpreadConstraints(newValues: io.k8s.api.core.v1.TopologySpreadConstraint*) : PodSpec = copy(topologySpreadConstraints = Some(topologySpreadConstraints.fold(newValues)(_ ++ newValues)))
  /** if topologySpreadConstraints has a value, transforms to the result of function*/
  def mapTopologySpreadConstraints(f: Seq[io.k8s.api.core.v1.TopologySpreadConstraint] => Seq[io.k8s.api.core.v1.TopologySpreadConstraint]) : PodSpec = copy(topologySpreadConstraints = topologySpreadConstraints.map(f))

  /** Returns a new data with overhead set to new value */
  def withOverhead(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : PodSpec = copy(overhead = Some(value))
  /** Adds new values to overhead */
  def addOverhead(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : PodSpec = copy(overhead = Some(overhead.fold(newValues.toMap)(_ ++ newValues)))
  /** if overhead has a value, transforms to the result of function*/
  def mapOverhead(f: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity] => Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : PodSpec = copy(overhead = overhead.map(f))

  /** Returns a new data with tolerations set to new value */
  def withTolerations(value: Seq[io.k8s.api.core.v1.Toleration]) : PodSpec = copy(tolerations = Some(value))
  /** Appends new values to tolerations */
  def addTolerations(newValues: io.k8s.api.core.v1.Toleration*) : PodSpec = copy(tolerations = Some(tolerations.fold(newValues)(_ ++ newValues)))
  /** if tolerations has a value, transforms to the result of function*/
  def mapTolerations(f: Seq[io.k8s.api.core.v1.Toleration] => Seq[io.k8s.api.core.v1.Toleration]) : PodSpec = copy(tolerations = tolerations.map(f))

  /** Returns a new data with automountServiceAccountToken set to new value */
  def withAutomountServiceAccountToken(value: Boolean) : PodSpec = copy(automountServiceAccountToken = Some(value))
  /** if automountServiceAccountToken has a value, transforms to the result of function*/
  def mapAutomountServiceAccountToken(f: Boolean => Boolean) : PodSpec = copy(automountServiceAccountToken = automountServiceAccountToken.map(f))

  /** Returns a new data with nodeSelector set to new value */
  def withNodeSelector(value: Map[String, String]) : PodSpec = copy(nodeSelector = Some(value))
  /** Adds new values to nodeSelector */
  def addNodeSelector(newValues: (String, String)*) : PodSpec = copy(nodeSelector = Some(nodeSelector.fold(newValues.toMap)(_ ++ newValues)))
  /** if nodeSelector has a value, transforms to the result of function*/
  def mapNodeSelector(f: Map[String, String] => Map[String, String]) : PodSpec = copy(nodeSelector = nodeSelector.map(f))

  /** Returns a new data with hostPID set to new value */
  def withHostPID(value: Boolean) : PodSpec = copy(hostPID = Some(value))
  /** if hostPID has a value, transforms to the result of function*/
  def mapHostPID(f: Boolean => Boolean) : PodSpec = copy(hostPID = hostPID.map(f))

  /** Returns a new data with terminationGracePeriodSeconds set to new value */
  def withTerminationGracePeriodSeconds(value: Int) : PodSpec = copy(terminationGracePeriodSeconds = Some(value))
  /** if terminationGracePeriodSeconds has a value, transforms to the result of function*/
  def mapTerminationGracePeriodSeconds(f: Int => Int) : PodSpec = copy(terminationGracePeriodSeconds = terminationGracePeriodSeconds.map(f))

  /** Returns a new data with dnsConfig set to new value */
  def withDnsConfig(value: io.k8s.api.core.v1.PodDNSConfig) : PodSpec = copy(dnsConfig = Some(value))
  /** if dnsConfig has a value, transforms to the result of function*/
  def mapDnsConfig(f: io.k8s.api.core.v1.PodDNSConfig => io.k8s.api.core.v1.PodDNSConfig) : PodSpec = copy(dnsConfig = dnsConfig.map(f))

  /** Returns a new data with priorityClassName set to new value */
  def withPriorityClassName(value: String) : PodSpec = copy(priorityClassName = Some(value))
  /** if priorityClassName has a value, transforms to the result of function*/
  def mapPriorityClassName(f: String => String) : PodSpec = copy(priorityClassName = priorityClassName.map(f))

  /** Returns a new data with serviceAccountName set to new value */
  def withServiceAccountName(value: String) : PodSpec = copy(serviceAccountName = Some(value))
  /** if serviceAccountName has a value, transforms to the result of function*/
  def mapServiceAccountName(f: String => String) : PodSpec = copy(serviceAccountName = serviceAccountName.map(f))

  /** Returns a new data with restartPolicy set to new value */
  def withRestartPolicy(value: String) : PodSpec = copy(restartPolicy = Some(value))
  /** if restartPolicy has a value, transforms to the result of function*/
  def mapRestartPolicy(f: String => String) : PodSpec = copy(restartPolicy = restartPolicy.map(f))

  /** Returns a new data with resourceClaims set to new value */
  def withResourceClaims(value: Seq[io.k8s.api.core.v1.PodResourceClaim]) : PodSpec = copy(resourceClaims = Some(value))
  /** Appends new values to resourceClaims */
  def addResourceClaims(newValues: io.k8s.api.core.v1.PodResourceClaim*) : PodSpec = copy(resourceClaims = Some(resourceClaims.fold(newValues)(_ ++ newValues)))
  /** if resourceClaims has a value, transforms to the result of function*/
  def mapResourceClaims(f: Seq[io.k8s.api.core.v1.PodResourceClaim] => Seq[io.k8s.api.core.v1.PodResourceClaim]) : PodSpec = copy(resourceClaims = resourceClaims.map(f))

  /** Returns a new data with hostUsers set to new value */
  def withHostUsers(value: Boolean) : PodSpec = copy(hostUsers = Some(value))
  /** if hostUsers has a value, transforms to the result of function*/
  def mapHostUsers(f: Boolean => Boolean) : PodSpec = copy(hostUsers = hostUsers.map(f))

  /** Returns a new data with runtimeClassName set to new value */
  def withRuntimeClassName(value: String) : PodSpec = copy(runtimeClassName = Some(value))
  /** if runtimeClassName has a value, transforms to the result of function*/
  def mapRuntimeClassName(f: String => String) : PodSpec = copy(runtimeClassName = runtimeClassName.map(f))

  /** Returns a new data with readinessGates set to new value */
  def withReadinessGates(value: Seq[io.k8s.api.core.v1.PodReadinessGate]) : PodSpec = copy(readinessGates = Some(value))
  /** Appends new values to readinessGates */
  def addReadinessGates(newValues: io.k8s.api.core.v1.PodReadinessGate*) : PodSpec = copy(readinessGates = Some(readinessGates.fold(newValues)(_ ++ newValues)))
  /** if readinessGates has a value, transforms to the result of function*/
  def mapReadinessGates(f: Seq[io.k8s.api.core.v1.PodReadinessGate] => Seq[io.k8s.api.core.v1.PodReadinessGate]) : PodSpec = copy(readinessGates = readinessGates.map(f))

  /** Returns a new data with activeDeadlineSeconds set to new value */
  def withActiveDeadlineSeconds(value: Int) : PodSpec = copy(activeDeadlineSeconds = Some(value))
  /** if activeDeadlineSeconds has a value, transforms to the result of function*/
  def mapActiveDeadlineSeconds(f: Int => Int) : PodSpec = copy(activeDeadlineSeconds = activeDeadlineSeconds.map(f))

  /** Returns a new data with hostNetwork set to new value */
  def withHostNetwork(value: Boolean) : PodSpec = copy(hostNetwork = Some(value))
  /** if hostNetwork has a value, transforms to the result of function*/
  def mapHostNetwork(f: Boolean => Boolean) : PodSpec = copy(hostNetwork = hostNetwork.map(f))

  /** Returns a new data with securityContext set to new value */
  def withSecurityContext(value: io.k8s.api.core.v1.PodSecurityContext) : PodSpec = copy(securityContext = Some(value))
  /** if securityContext has a value, transforms to the result of function*/
  def mapSecurityContext(f: io.k8s.api.core.v1.PodSecurityContext => io.k8s.api.core.v1.PodSecurityContext) : PodSpec = copy(securityContext = securityContext.map(f))
}

object PodSpec {

    implicit val encoder : Encoder[io.k8s.api.core.v1.PodSpec] = new Encoder[io.k8s.api.core.v1.PodSpec] {
        def apply[T : Builder](o: io.k8s.api.core.v1.PodSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("containers", o.containers)
            .write("schedulingGates", o.schedulingGates)
            .write("priority", o.priority)
            .write("hostIPC", o.hostIPC)
            .write("serviceAccount", o.serviceAccount)
            .write("schedulerName", o.schedulerName)
            .write("hostname", o.hostname)
            .write("imagePullSecrets", o.imagePullSecrets)
            .write("affinity", o.affinity)
            .write("os", o.os)
            .write("nodeName", o.nodeName)
            .write("ephemeralContainers", o.ephemeralContainers)
            .write("initContainers", o.initContainers)
            .write("shareProcessNamespace", o.shareProcessNamespace)
            .write("setHostnameAsFQDN", o.setHostnameAsFQDN)
            .write("enableServiceLinks", o.enableServiceLinks)
            .write("preemptionPolicy", o.preemptionPolicy)
            .write("dnsPolicy", o.dnsPolicy)
            .write("volumes", o.volumes)
            .write("hostAliases", o.hostAliases)
            .write("subdomain", o.subdomain)
            .write("topologySpreadConstraints", o.topologySpreadConstraints)
            .write("overhead", o.overhead)
            .write("tolerations", o.tolerations)
            .write("automountServiceAccountToken", o.automountServiceAccountToken)
            .write("nodeSelector", o.nodeSelector)
            .write("hostPID", o.hostPID)
            .write("terminationGracePeriodSeconds", o.terminationGracePeriodSeconds)
            .write("dnsConfig", o.dnsConfig)
            .write("priorityClassName", o.priorityClassName)
            .write("serviceAccountName", o.serviceAccountName)
            .write("restartPolicy", o.restartPolicy)
            .write("resourceClaims", o.resourceClaims)
            .write("hostUsers", o.hostUsers)
            .write("runtimeClassName", o.runtimeClassName)
            .write("readinessGates", o.readinessGates)
            .write("activeDeadlineSeconds", o.activeDeadlineSeconds)
            .write("hostNetwork", o.hostNetwork)
            .write("securityContext", o.securityContext)
            .build
        }
    }

    implicit val decoder: Decoder[PodSpec] = new Decoder[PodSpec] {
      def apply[T : Reader](t: T): Either[String, PodSpec] = for {
          obj <- ObjectReader(t)
          containers <- obj.read[Seq[io.k8s.api.core.v1.Container]]("containers")
          schedulingGates <- obj.readOpt[Seq[io.k8s.api.core.v1.PodSchedulingGate]]("schedulingGates")
          priority <- obj.readOpt[Int]("priority")
          hostIPC <- obj.readOpt[Boolean]("hostIPC")
          serviceAccount <- obj.readOpt[String]("serviceAccount")
          schedulerName <- obj.readOpt[String]("schedulerName")
          hostname <- obj.readOpt[String]("hostname")
          imagePullSecrets <- obj.readOpt[Seq[io.k8s.api.core.v1.LocalObjectReference]]("imagePullSecrets")
          affinity <- obj.readOpt[io.k8s.api.core.v1.Affinity]("affinity")
          os <- obj.readOpt[io.k8s.api.core.v1.PodOS]("os")
          nodeName <- obj.readOpt[String]("nodeName")
          ephemeralContainers <- obj.readOpt[Seq[io.k8s.api.core.v1.EphemeralContainer]]("ephemeralContainers")
          initContainers <- obj.readOpt[Seq[io.k8s.api.core.v1.Container]]("initContainers")
          shareProcessNamespace <- obj.readOpt[Boolean]("shareProcessNamespace")
          setHostnameAsFQDN <- obj.readOpt[Boolean]("setHostnameAsFQDN")
          enableServiceLinks <- obj.readOpt[Boolean]("enableServiceLinks")
          preemptionPolicy <- obj.readOpt[String]("preemptionPolicy")
          dnsPolicy <- obj.readOpt[String]("dnsPolicy")
          volumes <- obj.readOpt[Seq[io.k8s.api.core.v1.Volume]]("volumes")
          hostAliases <- obj.readOpt[Seq[io.k8s.api.core.v1.HostAlias]]("hostAliases")
          subdomain <- obj.readOpt[String]("subdomain")
          topologySpreadConstraints <- obj.readOpt[Seq[io.k8s.api.core.v1.TopologySpreadConstraint]]("topologySpreadConstraints")
          overhead <- obj.readOpt[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]("overhead")
          tolerations <- obj.readOpt[Seq[io.k8s.api.core.v1.Toleration]]("tolerations")
          automountServiceAccountToken <- obj.readOpt[Boolean]("automountServiceAccountToken")
          nodeSelector <- obj.readOpt[Map[String, String]]("nodeSelector")
          hostPID <- obj.readOpt[Boolean]("hostPID")
          terminationGracePeriodSeconds <- obj.readOpt[Int]("terminationGracePeriodSeconds")
          dnsConfig <- obj.readOpt[io.k8s.api.core.v1.PodDNSConfig]("dnsConfig")
          priorityClassName <- obj.readOpt[String]("priorityClassName")
          serviceAccountName <- obj.readOpt[String]("serviceAccountName")
          restartPolicy <- obj.readOpt[String]("restartPolicy")
          resourceClaims <- obj.readOpt[Seq[io.k8s.api.core.v1.PodResourceClaim]]("resourceClaims")
          hostUsers <- obj.readOpt[Boolean]("hostUsers")
          runtimeClassName <- obj.readOpt[String]("runtimeClassName")
          readinessGates <- obj.readOpt[Seq[io.k8s.api.core.v1.PodReadinessGate]]("readinessGates")
          activeDeadlineSeconds <- obj.readOpt[Int]("activeDeadlineSeconds")
          hostNetwork <- obj.readOpt[Boolean]("hostNetwork")
          securityContext <- obj.readOpt[io.k8s.api.core.v1.PodSecurityContext]("securityContext")
      } yield PodSpec (
          containers = containers,
          schedulingGates = schedulingGates,
          priority = priority,
          hostIPC = hostIPC,
          serviceAccount = serviceAccount,
          schedulerName = schedulerName,
          hostname = hostname,
          imagePullSecrets = imagePullSecrets,
          affinity = affinity,
          os = os,
          nodeName = nodeName,
          ephemeralContainers = ephemeralContainers,
          initContainers = initContainers,
          shareProcessNamespace = shareProcessNamespace,
          setHostnameAsFQDN = setHostnameAsFQDN,
          enableServiceLinks = enableServiceLinks,
          preemptionPolicy = preemptionPolicy,
          dnsPolicy = dnsPolicy,
          volumes = volumes,
          hostAliases = hostAliases,
          subdomain = subdomain,
          topologySpreadConstraints = topologySpreadConstraints,
          overhead = overhead,
          tolerations = tolerations,
          automountServiceAccountToken = automountServiceAccountToken,
          nodeSelector = nodeSelector,
          hostPID = hostPID,
          terminationGracePeriodSeconds = terminationGracePeriodSeconds,
          dnsConfig = dnsConfig,
          priorityClassName = priorityClassName,
          serviceAccountName = serviceAccountName,
          restartPolicy = restartPolicy,
          resourceClaims = resourceClaims,
          hostUsers = hostUsers,
          runtimeClassName = runtimeClassName,
          readinessGates = readinessGates,
          activeDeadlineSeconds = activeDeadlineSeconds,
          hostNetwork = hostNetwork,
          securityContext = securityContext
        )
    }
}

