package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** Represents a host path mapped into a pod. Host path volumes do not support ownership management or SELinux relabeling. */
final case class HostPathVolumeSource(
  path : String,
  `type` : Option[String] = None
) {

  /** Returns a new data with path set to new value */
  def withPath(value: String) : HostPathVolumeSource = copy(path = value)
  /** transforms path to result of function */
  def mapPath(f: String => String) : HostPathVolumeSource = copy(path = f(path))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : HostPathVolumeSource = copy(`type` = Some(value))
  /** if `type` has a value, transforms to the result of function*/
  def mapType(f: String => String) : HostPathVolumeSource = copy(`type` = `type`.map(f))
}

object HostPathVolumeSource {

    implicit val encoder : Encoder[io.k8s.api.core.v1.HostPathVolumeSource] = new Encoder[io.k8s.api.core.v1.HostPathVolumeSource] {
        def apply[T : Builder](o: io.k8s.api.core.v1.HostPathVolumeSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("path", o.path)
            .write("type", o.`type`)
            .build
        }
    }

    implicit val decoder: Decoder[HostPathVolumeSource] = new Decoder[HostPathVolumeSource] {
      def apply[T : Reader](t: T): Either[String, HostPathVolumeSource] = for {
          obj <- ObjectReader(t)
          path <- obj.read[String]("path")
          `type` <- obj.readOpt[String]("type")
      } yield HostPathVolumeSource (
          path = path,
          `type` = `type`
        )
    }
}

