package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s.utils._

/** ServerAddressByClientCIDR helps the client to determine the server address that they should use, depending on the clientCIDR that they match. */
final case class ServerAddressByClientCIDR(
  clientCIDR : String,
  serverAddress : String
) {

  /** Returns a new data with clientCIDR set to new value */
  def withClientCIDR(value: String) : ServerAddressByClientCIDR = copy(clientCIDR = value)
  /** transforms clientCIDR to result of function */
  def mapClientCIDR(f: String => String) : ServerAddressByClientCIDR = copy(clientCIDR = f(clientCIDR))

  /** Returns a new data with serverAddress set to new value */
  def withServerAddress(value: String) : ServerAddressByClientCIDR = copy(serverAddress = value)
  /** transforms serverAddress to result of function */
  def mapServerAddress(f: String => String) : ServerAddressByClientCIDR = copy(serverAddress = f(serverAddress))
}

object ServerAddressByClientCIDR {

    implicit val encoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR] = new Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR] {
        def apply[T : Builder](o: io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("clientCIDR", o.clientCIDR)
            .write("serverAddress", o.serverAddress)
            .build
        }
    }

    implicit val decoder: Decoder[ServerAddressByClientCIDR] = new Decoder[ServerAddressByClientCIDR] {
      def apply[T : Reader](t: T): Either[String, ServerAddressByClientCIDR] = for {
          obj <- ObjectReader(t)
          clientCIDR <- obj.read[String]("clientCIDR")
          serverAddress <- obj.read[String]("serverAddress")
      } yield ServerAddressByClientCIDR (
          clientCIDR = clientCIDR,
          serverAddress = serverAddress
        )
    }
}

