package io.k8s.kube_aggregator.pkg.apis.apiregistration.v1


/** APIServiceCondition describes the state of an APIService at a particular point */
final case class APIServiceCondition(
  status : String,
  `type` : String,
  reason : Option[String] = None,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None
) {

  /** Returns a new data with status set to new value */
  def withStatus(value: String) : APIServiceCondition = copy(status = value)
  /** transforms status to result of function */
  def mapStatus(f: String => String) : APIServiceCondition = copy(status = f(status))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : APIServiceCondition = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : APIServiceCondition = copy(`type` = f(`type`))

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : APIServiceCondition = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : APIServiceCondition = copy(reason = reason.map(f))

  /** Returns a new data with lastTransitionTime set to new value */
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : APIServiceCondition = copy(lastTransitionTime = Some(value))
  /** if lastTransitionTime has a value, transforms to the result of function*/
  def mapLastTransitionTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : APIServiceCondition = copy(lastTransitionTime = lastTransitionTime.map(f))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : APIServiceCondition = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : APIServiceCondition = copy(message = message.map(f))
}

