package io.k8s.kube_aggregator.pkg.apis.apiregistration.v1

import dev.hnaderi.k8s._

/** APIService represents a server for a particular GroupVersion. Name must be "version.group". */
final case class APIService(
  status : Option[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceStatus] = None,
  spec : Option[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apiregistration.k8s.io", "APIService", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceStatus) : APIService = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceStatus => io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceStatus) : APIService = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceSpec) : APIService = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceSpec => io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceSpec) : APIService = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : APIService = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : APIService = copy(metadata = metadata.map(f))
}

