package io.k8s.apimachinery.pkg.apis.meta.v1


/** Condition contains details for one aspect of the current state of this API Resource. */
final case class Condition(
  reason : String,
  status : String,
  lastTransitionTime : io.k8s.apimachinery.pkg.apis.meta.v1.Time,
  message : String,
  `type` : String,
  observedGeneration : Option[Int] = None
) {

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : Condition = copy(reason = value)
  /** transforms reason to result of function */
  def mapReason(f: String => String) : Condition = copy(reason = f(reason))

  /** Returns a new data with status set to new value */
  def withStatus(value: String) : Condition = copy(status = value)
  /** transforms status to result of function */
  def mapStatus(f: String => String) : Condition = copy(status = f(status))

  /** Returns a new data with lastTransitionTime set to new value */
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : Condition = copy(lastTransitionTime = value)
  /** transforms lastTransitionTime to result of function */
  def mapLastTransitionTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : Condition = copy(lastTransitionTime = f(lastTransitionTime))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : Condition = copy(message = value)
  /** transforms message to result of function */
  def mapMessage(f: String => String) : Condition = copy(message = f(message))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : Condition = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : Condition = copy(`type` = f(`type`))

  /** Returns a new data with observedGeneration set to new value */
  def withObservedGeneration(value: Int) : Condition = copy(observedGeneration = Some(value))
  /** if observedGeneration has a value, transforms to the result of function*/
  def mapObservedGeneration(f: Int => Int) : Condition = copy(observedGeneration = observedGeneration.map(f))
}

